package an0nym8us.positron.timers;

import an0nym8us.positron.gamemode.Arena.Phase;
import an0nym8us.positron.gamemode.PhaseManager;

public class PhaseTimer extends CountdownTimer
{
	public PhaseTimer(int arenaID, Phase startPhase)
	{
		super(arenaID, startPhase.duration, true);
	}
	
	PhaseManager GetPM()
	{
		return GetArena().GetPM();
	}
	

	@Override
	public void action()
	{
		if(GetArena().GetPhase() == Phase.Null && GetArena().preWorld.getPlayers().size() + GetArena().arenaWorld.getPlayers().size() >= GetArena().minPlayerAmount)
		{
			GetPM().NextPhase();
			this.countDown = GetPM().GetPhase().duration;
			this._cD = countDown;
			return;
		}
		
		if(GetArena().GetPhase() != Phase.Null)
		{
			GetPM().NextPhase();
			this.countDown = GetPM().GetPhase().duration;
			this._cD = countDown;
		}
	}
	
	public void ResetPhaseData()
	{
		this.countDown = GetPM().GetPhase().duration;
		this._cD = countDown;
	}
}
