package an0nym8us.positron.timers;

import java.util.HashMap;
import java.util.Map.Entry;

import org.bukkit.potion.PotionEffectType;

import an0nym8us.positron.Main;
import an0nym8us.positron.gamemode.Arena.Phase;
import an0nym8us.positron.gamemode.Arena.Team;
import an0nym8us.positron.gamemode.Nexus;
import an0nym8us.positron.gamemode.PPlayer;
import an0nym8us.utils.MCountdownTimer;

public class NexusTimer extends MCountdownTimer {

	int timerTicks;
	
	public NexusTimer(int arenaID)
	{
		super(arenaID, 250, 250, true);
	}

	@Override
	public void action()
	{
			timerTicks = (timerTicks + 1) % Integer.MAX_VALUE;
			
			for(Nexus n : Main.arena.nexuses)
			{
				HashMap<Team, Integer> damageLevel = new HashMap<Team, Integer>();
				
				for(Team t : Team.values())
				{
					damageLevel.put(t, 0);
				}
				
				// TODO: OPTIMALIZATION OF SEARCHING CODE
				for(PPlayer p : Main.arena.players)
				{
					try
					{
						if(!p.GetPlayer().getWorld().equals(n.location.getWorld()))
						{
							continue;
						}
						
						if(p.IsOnline() && !p.GetTeam().equals(n.team) && p.GetPlayer().getLocation().distance(n.location) <= 8 && !p.GetPlayer().hasPotionEffect(PotionEffectType.INVISIBILITY))
						{
							damageLevel.put(p.GetTeam(), damageLevel.get(p.GetTeam()) + 1);
						}
					}
					catch(Exception ex)
					{
						continue;
					}
				}
				
				Team team = null;
				int dmgLvl = -1;
				
				for(Entry<Team, Integer> e : damageLevel.entrySet())
				{
					if(e.getValue() > dmgLvl)
					{
						team = e.getKey();
						dmgLvl = e.getValue();
					}
					else if(e.getValue() == dmgLvl && e.getValue() != 0)
					{
						// STOP EXECUTION OF COMMAND - IF NEXUS IS CAPTURING BY THE SAME AMOUNT OF PLAYERS FROM TWO (OR MORE) TEAMS
						return;
					}
				}
				
				if(dmgLvl != 0)
				{
					dmgLvl = 12 - (dmgLvl / 2);
					
					if(dmgLvl < 3) { dmgLvl = 2; }
					
					if(timerTicks % dmgLvl == 0)
					{
						n.DamageNexus(Main.arena.GetPhase().equals(Phase.Phase5) ? 2 : 1, team, null); // TODO: Player UUID!
					}
				}
			}
	}
}
