package an0nym8us.positron.timers;

import java.util.EventObject;
import java.util.Timer;
import java.util.TimerTask;

import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

import an0nym8us.positron.Main;
import an0nym8us.positron.gamemode.Arena;

public abstract class CountdownTimer extends Timer {
	
	public int countDown;
	protected int _cD;
	
	protected int arenaID;
	
	TimerTask task;
	
	public boolean repeating;
	
	public CountdownTimer(int arenaID, int countDown)
	{
		this(arenaID, countDown, false);
	}
	
	public CountdownTimer(int arenaID, int countDown, boolean repeating)
	{
		this.arenaID = arenaID;
		this.countDown = countDown;
		this.repeating = repeating;
	}
	
	public void Start()
	{
		_cD = countDown;
		
		task = new TimerTask()
		{
			@Override
			public void run()
			{
				if(_cD <= 0)
				{
					try
					{
						action();
					}
					catch(Exception ex)
					{
						ex.printStackTrace();
					}
					
					if(!repeating)
					{
						this.cancel();
					}
					
					_cD = countDown;
				}
				
				_cD--;
			}
		};
		
		this.schedule(task, 1000, 1000);
	}
	
	public void Abort()
	{
		task.cancel();
	}
	
	protected Arena GetArena()
	{
		return Main.arena;
	}
	
	public abstract void action();
}
