package an0nym8us.positron.timers;

import java.util.List;
import java.util.UUID;

import org.bukkit.Bukkit;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

import com.comphenix.packetwrapper.WrapperPlayServerSpawnEntityLiving;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;

import an0nym8us.positron.Main;
import an0nym8us.positron.gamemode.PPlayer;

public class BossBarTimer extends CountdownTimer {

	public String text;
	
	public BossBarTimer(int arenaID, int countDown)
	{
		this(arenaID, countDown, null);
	}
	
	public BossBarTimer(int arenaID, int countDown, String text)
	{
		super(arenaID, countDown, true);
		
		this.text = text;
	}

	@Override
	public void action()
	{
		for(PPlayer p : Main.arena.players)
		{
			try
			{
				if(p == null || !p.IsOnline()) { continue; }
				
				 WrappedDataWatcher watcher = new WrappedDataWatcher();
				 watcher.setObject(0, (byte)0);
				 watcher.setObject(6, (float) (200 * Main.arena.GetPM().phaseTimer._cD / Main.arena.GetPM().phaseTimer.countDown));
				 
				 if (text == null && Main.arena.GetPhase().name != null)
				 {
					 watcher.setObject(10, Main.arena.GetPhase().name);
					 watcher.setObject(11, (byte) 1);
				 }
				 else
				 {
					 watcher.setObject(10, text);
					 watcher.setObject(11, (byte) 1);
				 }
				 
				WrapperPlayServerSpawnEntityLiving wp = new WrapperPlayServerSpawnEntityLiving();
				wp.setEntityID(6000);
				wp.setType(EntityType.ENDER_DRAGON);
				wp.setX(Bukkit.getPlayer(p.GetUUID()).getLocation().getX());
				wp.setY(Bukkit.getPlayer(p.GetUUID()).getLocation().getY() - 300);
				wp.setZ(Bukkit.getPlayer(p.GetUUID()).getLocation().getZ());
				wp.setYaw(0f);
				wp.setHeadPitch(2f);
				wp.setHeadYaw(1f);
				wp.setVelocityX(0);
				wp.setVelocityY(0);
				wp.setVelocityZ(0);
				wp.setMetadata(watcher);
				
				wp.sendPacket(Bukkit.getPlayer(p.GetUUID()));
			}
			catch(Exception ex) { continue; }
		}
	}

}
