package an0nym8us.positron.speciality.demoman;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.util.Vector;

import com.comphenix.packetwrapper.WrapperPlayServerWorldParticles;
import com.comphenix.packetwrapper.WrapperPlayServerWorldParticles.ParticleEffect;

import an0nym8us.positron.Main;
import an0nym8us.positron.gamemode.PPlayer;
import an0nym8us.positron.speciality.DemomanListener;
import an0nym8us.positron.speciality.ItemSkill;

public class Nuke extends ItemSkill
{
	public class NukeWrapper
	{
		public static final int TIMING = 140;
		public static final int POWER = 5;
		
		public final Material BLOCK = Material.OBSIDIAN;
		
		PPlayer owner;
		Location loc;
		int timing;
		
		public NukeWrapper(Location loc, PPlayer owner)
		{
			this.loc = loc;
			this.owner = owner;
			timing = TIMING;
			
			loc.getBlock().setType(BLOCK);
		}
		
		public boolean DecreaseTimer()
		{
			if(Math.sqrt(timing) == (int)Math.sqrt(timing) || timing <= 10)
			{
				Particles();
			}
			
			if(--timing == 0)
			{
				Boom();
				nukes.remove(this);
				
				return true;
			}
			
			return false;
		}
		
		private void Particles()
		{
			WrapperPlayServerWorldParticles wpw = new WrapperPlayServerWorldParticles();
			wpw.setLocation(new Location(loc.getWorld(), loc.getX() + 0.5, loc.getY() + 0.5, loc.getZ() + 0.5));
			wpw.setOffset(new Vector(0.3, 0.3, 0.3));
			wpw.setNumberOfParticles(6480);
			wpw.setParticleEffect(ParticleEffect.WITCH_MAGIC);
			wpw.setParticleSpeed(0.01f);
			
			for(Player p : Bukkit.getServer().getOnlinePlayers())
			{
				wpw.sendPacket(p);
			}
			
		}
		
		private void Boom()
		{
			loc.getBlock().setType(Material.AIR);
			
			loc.getWorld().createExplosion(loc, POWER);
		}
	}
	
	List<NukeWrapper> nukes;
	Runnable nukeSupport;
		
	public Nuke(int arenaID)
	{
		super(arenaID, 0, 60, DemomanListener.nuke, "Nuke");
		
		nukeSupport = new Runnable()
		{
			@Override
			public void run()
			{
				action();
			}
		};
		
		Bukkit.getScheduler().scheduleSyncRepeatingTask(Main.main, nukeSupport, 1, 1);

		nukes = new ArrayList<NukeWrapper>();
	}
	
	public void AddNuke(Location loc, PPlayer pplayer)
	{
		nukes.add(new NukeWrapper(loc, pplayer));
	}
	
	public void action()
	{
		super.action();
		
		for(int i = 0; i < nukes.size(); i++)
		{
			if(nukes.get(i).DecreaseTimer())
			{
				i--;
			}
		}
	}

	@Override
	protected void Execution(UUID uuid, Object... params)
	{
		PlayerInteractEvent ev = (PlayerInteractEvent)params[0];
		
		AddNuke(ev.getClickedBlock().getLocation(), GetArena().GetPPlayer(uuid));
	}
}
