package an0nym8us.positron.speciality;

import java.util.UUID;

import org.bukkit.event.Listener;

import an0nym8us.positron.Main;
import an0nym8us.positron.gamemode.Arena;
import an0nym8us.positron.gamemode.PPlayer;
import an0nym8us.positron.gamemode.Speciality;

public abstract class SpecialityListener implements Listener {

	int arenaID;
	int specialityID;
	
	public SpecialityListener(int arenaID, int specialityID)
	{
		this.arenaID = arenaID;
		this.specialityID = specialityID;
	}
	
	public int GetSPID()
	{
		return specialityID;
	}
	
	protected boolean CheckValidation(UUID uuid)
	{
		try
		{
			return Main.arena.GetPPlayer(uuid).GetSpeciality().id == specialityID;
		}
		catch(Exception ex)
		{
			return false;
		}
	}
	
	Arena GetArena()
	{
		return Main.arena;
	}
	
	public abstract void _preparePlayer(PPlayer player);
	public abstract void _unpreparePlayer(PPlayer player);
}
