package an0nym8us.positron.speciality;

import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

import org.bukkit.ChatColor;

import an0nym8us.positron.gamemode.PPlayer;
import an0nym8us.positron.timers.CountdownTimer;
import an0nym8us.positron.timers.PeriodTimer;

public abstract class Skill extends PeriodTimer
{
	class SkillWrapper
	{
		UUID uuid;
		int _cD;
		
		boolean isReady;
		
		boolean isGranted;
		
		public SkillWrapper(int arenaID, UUID uuid)
		{
			this(arenaID, uuid, true);
		}
		
		public SkillWrapper(int arenaID, UUID uuid, boolean isGranted)
		{
			this.uuid = uuid;
			this.isGranted = isGranted;
			
			isReady = true;
		}
		
		public void Grant()
		{
			isGranted = true;
		}
		
		public void UnGrant()
		{
			isGranted = false;
		}
		
		public void SetReady(boolean ready)
		{
			isReady = ready;
		}
		
		public void Use()
		{
			_cD = period;
			SetReady(false);
		}
	}
	
	protected static final String SKILL_TAG = "skill";
	int period; // PERIODS AMOUNT
	protected String name;
	
	List<SkillWrapper> grantedPPlayers;
	
	public Skill(int arenaID, int seconds, String name) //PERIOD IN SECONDS
	{
		super(arenaID);
		this.period = (int)(PERIOD_UNIT.convert(seconds, TimeUnit.SECONDS) / PERIOD);
		this.name = name;
		
		grantedPPlayers = new ArrayList<SkillWrapper>();
		
		Start();
	}
	
	protected SkillWrapper GetSW(UUID uuid)
	{
		for(SkillWrapper sw : grantedPPlayers)
		{
			if(sw.uuid.equals(uuid))
			{
				return sw;
			}
		}
		
		return null;
	}
	
	public void Grant(UUID player)
	{
		for(SkillWrapper sw : grantedPPlayers)
		{
			if(sw.uuid.equals(player)) { sw.Grant(); return; }
		}
		
		grantedPPlayers.add(new SkillWrapper(arenaID, player));
	}
	
	public void UnGrant(UUID player)
	{
		for(SkillWrapper sw : grantedPPlayers)
		{
			if(sw.uuid.equals(player))
			{
				sw.UnGrant();
				return;
			}
		}
	}
	
	protected boolean IsReady(UUID uuid)
	{
		return GetSW(uuid).isReady;
	}
	
	protected boolean IsGranted(UUID uuid)
	{
		return GetSW(uuid).isGranted;
	}
	
	public boolean Use(UUID uuid, Object... params)
	{
		if(IsReady(uuid) && IsGranted(uuid))
		{
			GetSW(uuid).Use();
			Execution(uuid, params);
			
			return true;
		}
		
		return false;
	}
	
	protected void Start()
	{
		task = new TimerTask()
		{
			@Override
			public void run()
			{
				//action();
				
				for(SkillWrapper sw : grantedPPlayers)
				{
					if(sw._cD != -1)
					{						
						if(sw._cD == 0)
						{
							try
							{
								sw.SetReady(true);
							}
							catch(Exception ex)
							{
								ex.printStackTrace();
							}
						}
						
						sw._cD--;
					}
				}
			}
		};
		
		this.schedule(task, TimeUnit.MILLISECONDS.convert(PERIOD, PERIOD_UNIT), TimeUnit.MILLISECONDS.convert(PERIOD, PERIOD_UNIT));
	}
	
	@SuppressWarnings("Unsafe")
	protected abstract void Execution(UUID uuid, Object... params);
}
