package an0nym8us.positron.speciality;

import java.util.ArrayList;
import java.util.List;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerFishEvent.State;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

import an0nym8us.positron.Main;
import an0nym8us.positron.gamemode.PPlayer;

public class ScoutListener extends SpecialityListener
{
	public ScoutListener(int arenaID, int specialityID)
	{
		super(arenaID, specialityID);
	}
	
	@EventHandler
	public void onPlayerFish(PlayerFishEvent ev)
	{
		try
		{
			Bukkit.getServer().getLogger().info(ev.getState().name());
			
			if(GetArena().GetPPlayer(ev.getPlayer().getUniqueId()).GetSpeciality().id == specialityID && !ev.getState().equals(State.FISHING))
			{
				org.bukkit.Material mat = ev.getHook().getLocation().getBlock().getType();
				
					if(!(ev.getHook().getLocation().getBlock().getType().equals(org.bukkit.Material.AIR) && ev.getHook().getLocation().add(0, -1, 0).getBlock().getType().equals(org.bukkit.Material.AIR)))
					{						
						ev.getPlayer().getItemInHand().setDurability((short) (ev.getPlayer().getItemInHand().getDurability() - 1));
						
						ev.getPlayer().setVelocity(ev.getHook().getLocation().toVector().subtract(ev.getPlayer().getLocation().toVector()).divide(new Vector(4, 4, 4)));
					}
			}
		}
		catch(Exception ex)
		{
			return;
		}
	}
	
	public void _preparePlayer(final PPlayer p)
	{
		Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(Main.main, new Runnable()
		{
			@Override
			public void run()
			{
				p.GetPlayer().addPotionEffect(new PotionEffect(PotionEffectType.SPEED, Integer.MAX_VALUE, 0));
			}
		}, 10L);
	}
	
	public void _unpreparePlayer(PPlayer p)
	{
		
	}
}
