package an0nym8us.positron.speciality;

import java.util.List;
import java.util.UUID;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

import an0nym8us.positron.ItemMarker;
import an0nym8us.positron.Main;
import an0nym8us.positron.gamemode.PPlayer;

public abstract class ItemSkill extends Skill implements Listener
{
	private static final String READY_SIGN = ChatColor.GREEN + "READY";
	protected ItemStack skillItem;
	
	private int id;
	
	public ItemSkill(int arenaID, int id, int period, ItemStack skillItem, String name)
	{
		super(arenaID, period, name);		
		this.skillItem = skillItem;
		this.id = id;
		
		Bukkit.getServer().getPluginManager().registerEvents(this, Main.main); // TODO: PROBABLY UNSAFE???
	}
	
	public ItemStack GetSkillItem()
	{
		ItemStack is = skillItem.clone();
		
		ItemMeta im = is.getItemMeta();
		List<String> lore = im.getLore();
		lore.add("+" + SKILL_TAG + ": " + Integer.toString(id));
		im.setLore(lore);
		is.setItemMeta(im);
		
		return is;
	}
	
	@EventHandler
	public void onPlayerInteract(PlayerInteractEvent ev)
	{
		if(ev.getItem() != null && ev.getItem().getItemMeta() != null && IsSkillIS(ev.getItem()))
		{
			Use(ev.getPlayer().getUniqueId(), ev);
			ev.setCancelled(true);
		}
	}
	
	private void UpdateItem()
	{
		for(SkillWrapper sw : grantedPPlayers)
		{
			PPlayer pplayer = GetArena().GetPPlayer(sw.uuid);
			
			try
			{
				for(ItemStack is : pplayer.GetPlayer().getInventory().getContents())
				{
					if(IsSkillIS(is))
					{
						ItemMeta im = is.getItemMeta();
						im.setDisplayName(ChatColor.RED + name + " " + (sw.isReady ? this.READY_SIGN : Integer.toString(sw._cD)));
						is.setItemMeta(im);
						break;
					}
				}
			}
			catch(Throwable t) { }
		}
	}
	
	@Override
	protected void action()
	{
		UpdateItem();
	}
		
	protected boolean IsSkillIS(ItemStack is)
	{
		try
		{
			return is.getItemMeta().getLore().contains("+" + SKILL_TAG + ": " + Integer.toString(id));
		}
		catch(Throwable t)
		{
			return false;
		}
	}
}
