package an0nym8us.positron.speciality;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

import an0nym8us.positron.gamemode.PPlayer;

public class EngineerListener extends SpecialityListener
{
	enum PadType
	{
		Launch(0, Material.REDSTONE_BLOCK),
		Jump(1, Material.QUARTZ_BLOCK),
		Speed(2, Material.EMERALD_BLOCK),
		Haste(3, Material.COAL_BLOCK),
		Overlord(666, Material.BEDROCK);
		
		public int padID;
		public Material padMaterial;
		
		PadType(int padID, Material padMaterial)
		{
			this.padID = padID;
			this.padMaterial = padMaterial;
		}
	}
	
	static class PadWrapper
	{
		public Location loc;
		public UUID owner;
		
		public PadWrapper(Location loc, UUID owner)
		{
			this.loc = loc;
			this.owner = owner;
		}
		
		public PadWrapper(Location loc, Player owner)
		{
			this.loc = loc;
			this.owner = owner.getUniqueId();
		}
		
		public static PadType GetType(List<PadWrapper> list, Location loc)
		{
			Material block = new Location(loc.getWorld(), loc.getX(), loc.getY() - 1, loc.getZ()).getBlock().getType();
			
			for(PadType type : PadType.values())
			{
				if(type.padMaterial.equals(block))
				{
					return type;
				}
			}
			
			return null;
		}
		
		public static void RemovePad(List<PadWrapper> list, PadWrapper pad)
		{
			pad.loc.getBlock().setType(Material.AIR);
			pad.loc.getBlock().getLocation().add(new Vector(0, 1, 0)).getBlock().setType(Material.AIR);
			
			list.remove(pad);
		}
		
		public static PadType GetTypeByMat(Material mat)
		{
			for(PadType type : PadType.values())
			{
				if(type.padMaterial.equals(mat))
				{
					return type;
				}
			}
			
			return null;
		}
		
		public static UUID GetOwner(List<PadWrapper> list, Location loc)
		{
			for(PadWrapper pad : list)
			{
				if(pad.loc.equals(loc))
				{
					return pad.owner;
				}
			}
			
			return null;
		}
		
		public static PadWrapper GetWrapper(List<PadWrapper> list, Location loc)
		{
			for(PadWrapper p : list)
			{
				if(p.loc.equals(loc))
				{
					return p;
				}
			}
			
			return null;
		}
	}
	
	List<PadWrapper> pads;
	
	public EngineerListener(int arenaID, int specialityID)
	{
		super(arenaID, specialityID);
		
		pads = new ArrayList<PadWrapper>();
	}

	@EventHandler
	public void onPlayerInteract(PlayerInteractEvent ev)
	{
		if(ev.getAction().equals(Action.PHYSICAL) && ev.getClickedBlock().getType().equals(Material.STONE_PLATE))
		{
			UUID owner = PadWrapper.GetOwner(pads, ev.getClickedBlock().getLocation());
			
			if(owner != null)
			{
				ev.setCancelled(true);
				StepOnPad(PadWrapper.GetType(pads, ev.getClickedBlock().getLocation()), ev.getPlayer(), owner);
			}
		}
	}
	
	@EventHandler
	public void onBlockPlace(BlockPlaceEvent ev)
	{
		if(GetArena().GetPPlayer(ev.getPlayer().getUniqueId()).GetSpeciality().id == specialityID)
		{
			if(ev.getBlock().getType().equals(Material.STONE_PLATE) && PadWrapper.GetTypeByMat(ev.getBlock().getLocation().add(new Vector(0, -1, 0)).getBlock().getType()) != null)
			{
				pads.add(new PadWrapper(ev.getBlock().getLocation(), ev.getPlayer()));
				ev.getPlayer().playSound(ev.getPlayer().getLocation(), Sound.NOTE_PLING, 1f, 1f);
			}
			else if(ev.getBlock().getType().equals(Material.CARPET) && ev.getBlock().getLocation().add(new Vector(0, -1, 0)).getBlock().getType().equals(Material.BEACON) && GetArena().GetPhase().ID >= 4)
			{
				pads.add(new PadWrapper(ev.getBlock().getLocation(), ev.getPlayer()));
				ev.getBlock().getWorld().playSound(ev.getPlayer().getLocation(), Sound.WITHER_SPAWN, 1f, 1f);
				
				ev.getBlock().getLocation().add(new Vector(0, -1, 0)).getBlock().setType(Material.BEDROCK);
				ev.getBlock().setType(Material.STONE_PLATE);
			}
		}
	}
	
	@EventHandler
	public void onBlockBreak(BlockBreakEvent ev)
	{
		if(PadWrapper.GetOwner(pads, ev.getBlock().getLocation()) != null && GetArena().GetPPlayer(ev.getPlayer().getUniqueId()).GetSpeciality().id == specialityID)
		{
			pads.remove(PadWrapper.GetWrapper(pads, ev.getBlock().getLocation()));
			ev.getBlock().setType(Material.AIR);
			ev.getBlock().getLocation().add(new Vector(0, -1, 0)).getBlock().setType(Material.AIR);
			
			ev.setCancelled(true);
		}
		else if(PadWrapper.GetOwner(pads, ev.getBlock().getLocation().add(new Vector(0, 1, 0))) != null && GetArena().GetPPlayer(ev.getPlayer().getUniqueId()).GetSpeciality().id == specialityID)
		{
			pads.remove(PadWrapper.GetWrapper(pads, ev.getBlock().getLocation().add(new Vector(0, 1, 0))));
			ev.getBlock().getLocation().add(new Vector(0, 1, 0)).getBlock().setType(Material.AIR);
			ev.getBlock().setType(Material.AIR);
			
			
			ev.setCancelled(true);
		}
	}
	
	@EventHandler
	public void onPlayerDeath(PlayerDeathEvent ev)
	{
		for(PadWrapper p : pads)
		{
			if(p.owner.equals(ev.getEntity().getUniqueId()))
			{
				PadWrapper.RemovePad(pads, p);
			}
		}
	}
	
	void StepOnPad(PadType type, Player player, UUID owner)
	{
		if(type.equals(PadType.Launch))
		{
			player.setVelocity(player.getLocation().getDirection().setY(3).multiply(new Vector(4, 4, 4)));
		}
		else if(type.equals(PadType.Haste))
		{
			player.addPotionEffect(new PotionEffect(PotionEffectType.FAST_DIGGING, 600, 0));
		}
		else if(type.equals(PadType.Jump))
		{
			player.addPotionEffect(new PotionEffect(PotionEffectType.JUMP, 400, 0));
		}
		else if(type.equals(PadType.Speed))
		{
			player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 800, 0));
		}
		else if(type.equals(PadType.Overlord) && GetArena().GetPhase().ID >= 5)
		{
			if(GetArena().GetNearestTeam(player.getLocation()).equals(GetArena().GetPlayerTeam(player.getUniqueId())))
			{
				player.addPotionEffect(new PotionEffect(PotionEffectType.INCREASE_DAMAGE, 700, 0));
				player.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 700, 0));
			}
		}
	}
	
	public void _preparePlayer(PPlayer p)
	{
		
	}
	
	public void _unpreparePlayer(PPlayer p)
	{
		
	}
}
