package an0nym8us.positron.scoreboard;

import java.util.HashMap;
import java.util.UUID;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import org.bukkit.scoreboard.Team;

import an0nym8us.positron.Main;
import an0nym8us.positron.gamemode.Arena;
import an0nym8us.positron.gamemode.PPlayer;

public class StatisticsManager {

	ScoreboardManager manager;
	Scoreboard nexusScoreboard;
	Team[] teams;
	Objective nexusObjective;
	Score[] nexusScores;
	
	int arenaID;
	
	public StatisticsManager(int arenaID, Arena arena)
	{
		this.arenaID = arenaID;
		
		manager = Bukkit.getScoreboardManager();		
		nexusScoreboard = manager.getNewScoreboard();
		
		teams = new Team[Arena.Team.values().length];		
		for(int i = 0; i < teams.length; i++)
		{
			teams[i] = nexusScoreboard.registerNewTeam(Arena.Team.values()[i].name);
			teams[i].setPrefix(Arena.Team.values()[i].chatColor.toString());
			teams[i].setCanSeeFriendlyInvisibles(true);
		}
		
		nexusObjective = nexusScoreboard.registerNewObjective("nexusLife", "dummy");
		nexusObjective.setDisplayName("Nexus' Status");
		nexusObjective.setDisplaySlot(DisplaySlot.SIDEBAR);
		
		nexusScores = new Score[arena.nexuses.size()];

		HashMap<Arena.Team, Integer> map = new HashMap<Arena.Team, Integer>();
		for(Arena.Team t : Arena.Team.values())
		{
			map.put(t, 1);
		}
		
		for(int i = 0; i < nexusScores.length; i++)
		{				
			nexusScores[i] = nexusObjective.getScore(arena.nexuses.get(i).team.chatColor + Integer.toString(map.get(arena.nexuses.get(i).team)) + ". " + arena.nexuses.get(i).team.name + ": ");
			nexusScores[i].setScore(arena.nexuses.get(i).GetHealth());
			
			map.put(arena.nexuses.get(i).team, map.get(arena.nexuses.get(i).team) + 1);
		}
	}
	
	public boolean AddPlayer(UUID uuid, Arena.Team arenaTeam)
	{
		return AddPlayer(Bukkit.getPlayer(uuid), arenaTeam);
	}
	
	public boolean AddPlayer(PPlayer player, Arena.Team arenaTeam)
	{
		return AddPlayer(player.GetPlayer(), arenaTeam);
	}
	
	public void SetScoreboard(Player player)
	{
		player.setScoreboard(nexusScoreboard);
	}
	
	public boolean AddPlayer(Player player, Arena.Team arenaTeam)
	{
		SetScoreboard(player);
		
		for(Team team : teams)
		{
			if(team.getName().equals(arenaTeam.name))
			{
				team.addPlayer(player);
				
				return true;
			}
		}
		
		return false;
	}
	
	public void RemovePlayer(Player player)
	{
		player.setScoreboard(manager.getNewScoreboard());
	}
	
	public boolean UpdateScores()
	{
		try
		{
			HashMap<Arena.Team, Integer> map = new HashMap<Arena.Team, Integer>();
			for(Arena.Team t : Arena.Team.values())
			{
				map.put(t, 1);
			}
			
			for(int i = 0; i < nexusScores.length; i++)
			{
				nexusScoreboard.resetScores(nexusScores[i].getEntry());
			}
			
			for(int i = 0; i < nexusScores.length; i++)
			{
				if(GetArena().nexuses.get(i).GetHealth() <= 0)
				{
					continue;
				}
				
				nexusScores[i] = nexusObjective.getScore(GetArena().nexuses.get(i).team.chatColor + Integer.toString(map.get(GetArena().nexuses.get(i).team)) + ". " + GetArena().nexuses.get(i).team.name + ": ");
				nexusScores[i].setScore(GetArena().nexuses.get(i).GetHealth());
				
				map.put(GetArena().nexuses.get(i).team, map.get(GetArena().nexuses.get(i).team) + 1);
			}
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
			
			return false;
		}
		
		return true;
	}
	
	Arena GetArena()
	{
		return Main.arena;
	}
}
