package an0nym8us.positron.modules.furnace;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryHolder;

import net.minecraft.server.v1_7_R4.Item;
import net.minecraft.server.v1_7_R4.ItemStack;
import net.minecraft.server.v1_7_R4.RecipesFurnace;
import net.minecraft.server.v1_7_R4.TileEntityFurnace;

import org.bukkit.craftbukkit.v1_7_R4.entity.*;

import an0nym8us.positron.Main;
import an0nym8us.positron.gamemode.Speciality;

public class PTEFurnace extends TileEntityFurnace
{
    // ticksForCurrentFuel is private in Spigot
    private static Field _tfcf;
    private static Field _total;
    // To access the chests
    private ItemStack[] contents = new ItemStack[3];
    public int link = 0;
    // For custom stuff
    private double burnSpeed = 1D;
    private double meltSpeed = 1D;
    // I'm internally using "myCookTime" to not lose any precision, but for displaying the progress I still have to use "cookTime"
    private double myCookTime = 0D;
    // Call me paranoid, but this has to be checked
    private int lastID = 0;
    // Increases performance (or should at least)
    private long lastCheck = 0L;
    UUID owner;
    static
    {
        try
        {
            _tfcf = TileEntityFurnace.class.getDeclaredField("ticksForCurrentFuel");
            _tfcf.setAccessible(true);
            _total = TileEntityFurnace.class.getDeclaredField("cookTime");
            _total.setAccessible(true);
        }
        catch(Exception e)
        {
            e.printStackTrace();
        }
    }

    // New VTE
    public PTEFurnace(UUID owner)
    {
    	this.owner = owner;
        burnTime = 0;
        cookTime = 0;
        cookTimeTotal(0);
        //ticksForCurrentFuel = 0;
        setTFCF(0);
    }
    
    public ItemStack GetIS(int slot)
    {
    	return contents[slot];
    }

    public void tick(int ticks)
    {
        int newID = contents[0] == null ? 0 : Item.getId(contents[0].getItem());
        // Has the item been changed?
        if(newID != lastID)
        {
            // Then reset the progress!
            myCookTime = 0.0D;
            lastID = newID;
            // And, most important: change the melt speed
            meltSpeed = getMeltSpeed(contents[0]);
        }
        // So, can we now finally burn?
        if(canHasBURN() && !isBurning() && (getFuelTime(contents[1]) > 0))
        {
            // I have no idea what "ticksForCurrentFuel" is good for, but it works fine like this
            burnTime = getFuelTime(contents[1]);
            cookTimeTotal(this.getFuelTime(contents[0]));
            setTFCF(burnTime);
            // Before we remove the item: how fast does it burn?
            burnSpeed = getBurnSpeed(contents[1]);
            // If it's a container item (lava bucket), we only consume its contents (not like evil Notch!)
            if(Item.getId(contents[1].getItem()) == Material.LAVA_BUCKET.getId()) // Derpnote
            {
                contents[1] = new ItemStack(Item.getById(Material.BUCKET.getId()));  // Derpnote
            }
            // If it's not a container, consume it! Om nom nom nom!
            else
            {
                contents[1].count--;
                // Let 0 be null
                if(contents[1].count <= 0)
                {
                    contents[1] = null;
                }
            }
        }
        // Now, burning?
        if(isBurning())
        {
            // Then move on
            burnTime -= ticks;
            // I'm using a double here because of the custom recipes.
            // The faster this fuel burns and the faster the recipe melts, the faster we're done
            myCookTime += burnSpeed * meltSpeed * ((double)ticks);
            if(Main.main.arena.GetPPlayer(owner).GetSpeciality().equals(Speciality.Smelter)) { myCookTime = myCookTime * 1.25d; }
            
            // Finished burning? // TODO: int time = ???(contents[0]);???
            int time = 200;
            while(myCookTime >= time)
            {
                myCookTime -= time;
                burn();
            }
        }
        // If it's not burning, we reset the burning progress!
        else if(!canHasBURN())
        {
            myCookTime = 0.0D;
        }
        // And for the display (I'm using floor rather than round to not cause the client to do shit when we not really reached cookTimeTotal):
        cookTime = (int)myCookTime;
    }

    public boolean isFine()
    {
        return ((myCookTime > 0.0D) || (getFuelTime(contents[1]) > 0)) && canHasBURN();
    }

    // This needs a little addition
    public boolean isBurning()
    {
        return (burnTime > 0) && (burnSpeed > 0.0D) && canHasBURN();
    }

    private ItemStack getBurnResult(ItemStack item)
    {
        if(item == null)
        {
            return null;
        }
        // CUSTOM RECIPE HERE
        return RecipesFurnace.getInstance().getResult(item); // Derpnote
    }

    private double getMeltSpeed(ItemStack item)
    {
        if(item == null)
        {
            return 0.0D;
        }
        // CUSTOM RECIPE HERE
        return 1.0D;
    }

    private int getFuelTime(ItemStack item)
    {
        if(item == null)
        {
            return 0;
        }
        int i = Item.getId(item.getItem());
        // CUSTOM FUEL HERE
        // Lava should melt 128 items, not 100
        if(i == Material.LAVA_BUCKET.getId())
        {
            return 25600;
        }
        else
        {
            return fuelTime(item);
        }
    }

    private double getBurnSpeed(ItemStack item)
    {
        if(item == null)
        {
            return 0.0D;
        }
        // CUSTOM FUEL HERE
        return 1.0D;
    }

    private boolean canHasBURN()
    {
        // No ingredient, no recipe
        if(contents[0] == null)
        {
            return false;
        }
        ItemStack itemstack = getBurnResult(contents[0]);
        // No recipe, no burning
        if(itemstack == null)
        {
            return false;
        }
        // Free space? Let's burn!
        else if(contents[2] == null)
        {
            return true;
        }
        // Materials don't match? Too bad.
        else if(!contents[2].doMaterialsMatch(itemstack))
        {
            return false;
        }
        // As long as there is space, we can burn
        else if((contents[2].count + itemstack.count <= getMaxStackSize()) && (contents[2].count + itemstack.count <= contents[2].getMaxStackSize()))
        {
            return true;
        }
        return false;
    }

    public void burn()
    {
        // Can't burn? Goodbye
        if(!canHasBURN())
        {
            return;
        }
        ItemStack itemstack = getBurnResult(contents[0]);
        // Nothing in there? Then put something there.
        if(contents[2] == null)
        {
            contents[2] = itemstack.cloneItemStack();
        }
        // Burn ahead
        else if(contents[2].doMaterialsMatch(itemstack))
        {
            contents[2].count += itemstack.count;
        }
        // And consume the ingredient item
        // Goddamn, you have container functions, use them! Notch!
        /*if(contents[0].getItem().v()) // Derpnote //?
        {
           // contents[0] = new ItemStack(); // Derpnote
        	contents[0].count--;
        }
        else
        {*/
            contents[0].count--;
            // Let 0 be null
            if(contents[0].count <= 0)
            {
                contents[0] = null;
            }
        //}
    }

    /***** The following methods are only here because they interact with the contents array, which is private *****/

    public ItemStack[] getContents()
    {
        return contents;
    }

    public int getSize()
    {
        return contents.length;
    }

    public ItemStack getItem(int i)
    {
        return contents[i];
    }

    public ItemStack splitStack(int i, int j)
    {
        if(contents[i] != null)
        {
            ItemStack itemstack;
            if(contents[i].count <= j)
            {
                itemstack = contents[i];
                contents[i] = null;
                return itemstack;
            }
            else
            {
                itemstack = contents[i].a(j); // Derpnote
                if(contents[i].count == 0)
                {
                    contents[i] = null;
                }
                return itemstack;
            }
        }
        else
        {
            return null;
        }
    }

    public ItemStack splitWithoutUpdate(int i)
    {
        if(contents[i] != null)
        {
            ItemStack itemstack = contents[i];
            contents[i] = null;
            return itemstack;
        }
        else
        {
            return null;
        }
    }

    public void setItem(int i, ItemStack itemstack)
    {
        contents[i] = itemstack;
        if(itemstack != null && itemstack.count > getMaxStackSize())
        {
            itemstack.count = getMaxStackSize();
        }
    }

    private void setTFCF(int value)
    {
        try
        {
            _tfcf.setInt(this, value);
        }
        catch(Exception e)
        {
            e.printStackTrace();
        }
    }

    private int getTFCF()
    {
        try
        {
            return _tfcf.getInt(this);
        }
        catch(Exception e)
        {
            e.printStackTrace();
            return 0;
        }
    }

    private int cookTimeTotal()
    {
        try
        {
            return _total.getInt(this);
        }
        catch(Exception e)
        {
            e.printStackTrace();
            return 0;
        }
    }

    private void cookTimeTotal(int i)
    {
        try
        {
            _total.setInt(this, i);
        }
        catch(Exception e)
        {
            e.printStackTrace();
        }
    }

    // Compatibility
    public InventoryHolder getOwner()
    {
        return null;
    }

    public void onOpen(CraftHumanEntity who)
    {
    }

    public void onClose(CraftHumanEntity who)
    {
    }

    public List<HumanEntity> getViewers()
    {
        return new ArrayList<HumanEntity>();
    }
}
