package an0nym8us.positron.modules.furnace;

import org.bukkit.craftbukkit.v1_7_R4.inventory.CraftItemStack;
import org.bukkit.entity.Player;

import net.minecraft.server.v1_7_R4.EntityHuman;
import net.minecraft.server.v1_7_R4.EntityPlayer;
import net.minecraft.server.v1_7_R4.ItemStack;
import net.minecraft.server.v1_7_R4.TileEntityFurnace;
import net.minecraft.server.v1_7_R4.ContainerFurnace;

public class PFurnace extends ContainerFurnace
{
	protected EntityPlayer player;
    public TileEntityFurnace _data;
    private final boolean _readonly;

    public PFurnace(EntityPlayer player, TileEntityFurnace data, boolean canEdit)
    {
        super(player.inventory, data);
        this.checkReachable = false;
        this._data = data;
        this.player = player;
        this._readonly = !canEdit;
    }
    
    public final ItemStack clickItem(int slot, int mouse, int shift, EntityHuman human)
    {
        ItemStack item;
        if(allowClick(slot, mouse, shift, human))
        {
            item = super.clickItem(slot, mouse, shift, human);
        }
        else
        {
            item = human.inventory.getCarried();
            update();
        }
        return item;
    }

    public boolean allowClick(int slot, int mouse, int shift, EntityHuman human)
    {
        if(_readonly)
        {
            return false;
        }
        if(shift == 1)
        {
            if(slot >= _data.getSize())
            {
                return isItemAllowed(human, human.inventory.getItem(toInventorySlot(slot - _data.getSize())));
            }
            return true;
        }
        else if((slot >= 0) && (slot < _data.getSize()))
        {
            return isItemAllowed(human, human.inventory.getCarried());
        }
        return true;
    }

    protected int toInventorySlot(int slot)
    {
        return (slot >= 27) ? (slot - 27) : (slot + 9);
    }

    private boolean isItemAllowed(EntityHuman human, ItemStack item)
    {
        return true;
    }

    protected void update()
    {
        player.updateInventory(player.activeContainer);
    }
}
