package an0nym8us.positron.modules;

import org.bukkit.Bukkit;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;

import an0nym8us.positron.Main;
import an0nym8us.positron.gamemode.Arena;

public abstract class Module implements Listener
{
	int arenaID;
	boolean isEnabled;
	
	public Module(int arenaID)
	{
		this(arenaID, true);
	}
	
	public Module(int arenaID, boolean isEnabled)
	{
		this.arenaID = arenaID;
		this.isEnabled = isEnabled;
		
		if(isEnabled)
		{
			Bukkit.getServer().getPluginManager().registerEvents(this, Main.main);
		}
	}
	
	public void Enable()
	{
		Bukkit.getServer().getPluginManager().registerEvents(this, Main.main);
		isEnabled = true;
	}
	
	public void Disable()
	{
		HandlerList.unregisterAll(this);
		isEnabled = false;
	}
	
	protected Arena GetArena()
	{
		return Main.main.arena;
	}
}
