package an0nym8us.positron.modules;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.UUID;





import net.minecraft.server.v1_7_R4.*;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_7_R4.inventory.CraftInventoryCustom;
import org.bukkit.craftbukkit.v1_7_R4.inventory.CraftInventoryFurnace;
import org.bukkit.craftbukkit.v1_7_R4.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.Inventory;

import an0nym8us.blitz.utils.BlitzUtils;
import an0nym8us.positron.Main;
import an0nym8us.positron.gamemode.Arena.Team;
import an0nym8us.positron.modules.furnace.PFurnace;
import an0nym8us.positron.modules.furnace.PTEFurnace;

public class EnderFurnaceModule extends Module
{
	Inventory furnace;
	public HashMap<UUID, PFurnace[]> efMap;
	
	public EnderFurnaceModule(int arenaID)
	{
		super(arenaID);
		efMap = new HashMap<UUID, PFurnace[]>();
		
		Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask(Main.main, new Runnable()
		{
			@Override
			public void run()
			{
				for(Entry<UUID, PFurnace[]> e : efMap.entrySet())
				{
					for(int i = 0; i < e.getValue().length; i++)
					{
						((PTEFurnace)e.getValue()[i]._data).tick(1);
						e.getValue()[i].b();
					}
				}
			}
		}, 1, 1);
	}
	
	public FurnaceRecipe[] GetRecipes()
	{
		try
		{
			Field f = RecipesFurnace.class.getDeclaredField("recipes");
			f.setAccessible(true);
			Map recipes = (Map)f.get(RecipesFurnace.getInstance());
			
			FurnaceRecipe[] res = new FurnaceRecipe[recipes.size()];
			
			for(int i = 0; i < res.length; i++)
			{
				ItemStack is0 = (ItemStack) recipes.keySet().toArray()[i];
				ItemStack is1 = (ItemStack) recipes.get(is0);
				
				res[i] = new FurnaceRecipe(CraftItemStack.asBukkitCopy(is1), CraftItemStack.asBukkitCopy(is0).getType());
			}
			
			return res;
		}
		catch(Throwable t)
		{
			return null;
		}
	}
	
	@EventHandler
	public void onPlayerJoin(PlayerJoinEvent ev)
	{
		if(efMap.containsKey(ev.getPlayer().getUniqueId())) { return; }
		PFurnace[] pfa = new PFurnace[4];
		
		for(int i = 0; i < 4; i++)
		{
			pfa[i] = new PFurnace(((CraftPlayer)ev.getPlayer()).getHandle(), new PTEFurnace(ev.getPlayer().getUniqueId()), true);
		}
		
		efMap.put(ev.getPlayer().getUniqueId(), pfa);
	}
	
    public static void openWindow(EntityPlayer player, Container container, String name, String id, int size)
    {
        if(name.length() > 32)
        {
            name = name.substring(0, 32);
        }
        int containerId = player.nextContainerCounter();
        player.playerConnection.sendPacket(new PacketPlayOutOpenWindow(containerId, 2, name, size, false));
        player.playerConnection.sendPacket(new net.minecraft.server.v1_7_R4.PacketPlayOutSetSlot(containerId, 0, ((PFurnace)container)._data.getItem(0)));
        player.playerConnection.sendPacket(new net.minecraft.server.v1_7_R4.PacketPlayOutSetSlot(containerId, 1, ((PFurnace)container)._data.getItem(1)));
        player.playerConnection.sendPacket(new net.minecraft.server.v1_7_R4.PacketPlayOutSetSlot(containerId, 2, ((PFurnace)container)._data.getItem(2)));
        player.activeContainer = container;
        container.windowId = containerId;
        
        try
        {
        	container.addSlotListener((ICrafting)player);
        }
        catch(Exception ex)
        {
        	return;
        }
    }
	
	@EventHandler
	public void onPlayerInteract(PlayerInteractEvent ev)
	{
		if(ev.getClickedBlock() == null) { return; }
		
		Team team = GetArena().GetPPlayer(ev.getPlayer().getUniqueId()).GetTeam();
		
		for(int i = 0; i < GetArena().enderFurnaces.get(team).size(); i++)
		{
			if(GetArena().enderFurnaces.get(team).get(i).equals(ev.getClickedBlock().getLocation()))
			{
				if(efMap.get(ev.getPlayer().getUniqueId()).length > i)
				{
					openWindow(((CraftPlayer)ev.getPlayer()).getHandle(), efMap.get(ev.getPlayer().getUniqueId())[i], "Furnace::", "ID", 3);
					
					Main.SendMsg(ev.getPlayer(), "EnderFurnace[" + Integer.toString(i) + "] opened!");
					ev.setCancelled(true);
				}
			}
		}
	}
}
