package an0nym8us.positron.menu.shops;

import org.bukkit.Material;
import org.bukkit.block.Sign;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class WeaponsShop extends Shop
{
	public WeaponsShop()
	{
		super(27, "Weapons");
		
		AddItem(new ItemStack(Material.IRON_SWORD, 1), 5);
		AddItem(new ItemStack(Material.IRON_HELMET, 1), 7);
		AddItem(new ItemStack(Material.IRON_CHESTPLATE, 1), 10);
		AddItem(new ItemStack(Material.IRON_LEGGINGS, 1), 9);
		AddItem(new ItemStack(Material.IRON_BOOTS, 1), 6);
		AddItem(new ItemStack(Material.COOKED_BEEF, 8), 3);
		AddItem(new ItemStack(Material.BOW, 1), 5);
		AddItem(new ItemStack(Material.ARROW, 16), 3);
		AddItem(new ItemStack(Material.FISHING_ROD, 1), 5);
		AddItem(new ItemStack(Material.BOOK, 3), 5);
		
		ItemStack sword = new ItemStack(Material.IRON_SWORD, 1);
		sword.addEnchantment(Enchantment.DAMAGE_ALL, 1);
		
		AddItem(sword, 7);
		
		ItemStack bow = new ItemStack(Material.BOW, 1);
		bow.addEnchantment(Enchantment.ARROW_DAMAGE, 1);
		
		AddItem(bow, 7);
	}
	
	@EventHandler
	public void onPlayerInteract(PlayerInteractEvent ev)
	{
		try
		{
			if(ev.getClickedBlock().getType().equals(Material.SIGN_POST) || ev.getClickedBlock().getType().equals(Material.WALL_SIGN))
			{
				Sign sign = (Sign)ev.getClickedBlock().getState();
				
				if(sign.getLine(0).equals("Shop") && sign.getLine(1).equals(this.title))
				{
					ev.getPlayer().openInventory(this.CreateInventory(ev.getPlayer().getUniqueId()));
				}
			}
		}
		catch(Exception ex)
		{
			return;
		}
	}
}
