package an0nym8us.positron.menu.shops;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

import an0nym8us.utils.menu.DynamicMenu;
import an0nym8us.utils.menu.Menu;

public class Shop extends Menu
{
	public class ShopWrapper
	{
		public int price;		
		public ItemStack item;
		
		public ShopWrapper(int price, ItemStack item)
		{
			this.price = price;
			this.item = item;
		}
	}

	List<ShopWrapper> shopList;
	
	public Shop(int slots, String name)
	{
		super(slots, name);
		
		shopList = new ArrayList<ShopWrapper>();
	}
	
	
	public void AddItem(ItemStack i, int price)
	{
		try
		{
			shopList.add(new ShopWrapper(price, i));
			
			itemStacks[shopList.size() - 1] = shopList.get(shopList.size() - 1).item;
			
			ItemMeta im = itemStacks[shopList.size() - 1].getItemMeta();				
			List<String> lore = Arrays.asList(ChatColor.GOLD + "Cena: " + Integer.toString(shopList.get(shopList.size() - 1).price));				
			im.setLore(lore);
				
			itemStacks[shopList.size() - 1].setItemMeta(im);
			
			actions.put(shopList.size() - 1, this.getClass().getMethod("BuyItem", Shop.class, InventoryClickEvent.class));
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}
	}
	
	ShopWrapper GetShopWrapper(int invSlot)
	{
		return shopList.get(invSlot);
	}
	
	public void BuyItem(Shop menu, InventoryClickEvent ev)
	{
		ShopWrapper sw = GetShopWrapper(ev.getRawSlot());
		
		if(ev.getWhoClicked().getInventory().containsAtLeast(new ItemStack(Material.GOLD_INGOT, 1), sw.price))
		{
			ev.getWhoClicked().getInventory().removeItem(new ItemStack(Material.GOLD_INGOT, sw.price));			
			ev.getWhoClicked().getInventory().addItem(sw.item);
			
			SendOK((Player)ev.getWhoClicked(), sw.item.getType().name(), sw.price);
		}
		else
		{
			SendError((Player)ev.getWhoClicked());
		}
	}
	
	void SendOK(Player player, String name, int price)
	{
		an0nym8us.positron.Main.SendMsg(player, ChatColor.GREEN + "Kupiles item " + name + " za " + price + " sztabek zlota!");
	}
	
	void SendError(Player player)
	{
		an0nym8us.positron.Main.SendMsg(player, ChatColor.DARK_RED + "Masz za malo sztabek zlota!");
	}
}
