package an0nym8us.positron.menu;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.scoreboard.Team;

import com.comphenix.packetwrapper.WrapperPlayServerSpawnEntityLiving;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.nbt.NbtCompound;
import com.comphenix.protocol.wrappers.nbt.NbtFactory;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

import an0nym8us.positron.Main;
import an0nym8us.positron.gamemode.Arena;
import an0nym8us.positron.listeners.ManagementListener;
import an0nym8us.utils.menu.DynamicMenu;
import an0nym8us.utils.menu.Menu;

public class TeamJoinMenu extends DynamicMenu {

	public static final ItemStack openItem = new ItemStack(Material.SLIME_BALL, 1);
	
	static
	{
		ItemMeta im = openItem.getItemMeta();
		im.setDisplayName(ChatColor.LIGHT_PURPLE + "Choose team");
		im.addEnchant(Enchantment.SILK_TOUCH, 1, true);
		im.removeEnchant(Enchantment.SILK_TOUCH);
		List<String> lore = new ArrayList<String>();
		lore.add(ManagementListener.SOULBOUND);
		im.setLore(lore);
		openItem.setItemMeta(im);
	}
	
	public TeamJoinMenu() throws NoSuchMethodException, SecurityException
	{
		super(9, ChatColor.DARK_GRAY + "Choose team");
		
		ItemMeta im = openItem.getItemMeta();
		im.setDisplayName(ChatColor.LIGHT_PURPLE + "Choose team");
		im.addEnchant(Enchantment.SILK_TOUCH, 1, true);
		im.removeEnchant(Enchantment.SILK_TOUCH);
		openItem.setItemMeta(im);
		
		SetSlot(new ItemStack(Material.WOOL, 1, (short)13), 0);
		SetSlot(new ItemStack(Material.WOOL, 1, (short)14), 1);
		SetSlot(new ItemStack(Material.WOOL, 1, (short)11), 2);
		SetSlot(new ItemStack(Material.WOOL, 1, (short)4), 3);
		
		for(int i = 0; i < size; i++)
		{
			if(itemStacks[i] != null)
			{
				actions.put(i, this.getClass().getMethod("ClickEH", Menu.class, InventoryClickEvent.class));
			}
		}
	}
	
	@EventHandler
	public void onPlayerInteract(PlayerInteractEvent ev)
	{
		try
		{
			if(ev.getItem().equals(openItem))
			{
				ev.getPlayer().openInventory(this.CreateInventory(ev.getPlayer().getUniqueId()));
			}
		}
		catch(Exception ex)
		{
			return;
		}
	}
	
	public void ClickEH(Menu menu, InventoryClickEvent ev)
	{
		try
		{
			if(Main.arena.PlayerJoinTeam(ev.getWhoClicked().getUniqueId(), Arena.Team.GetByID(ev.getSlot())))
			{
				Main.SendMsg((Player)ev.getWhoClicked(), "You have joined " + Arena.Team.GetByID((ev.getSlot())).chatColor + "" + Arena.Team.GetByID((ev.getSlot())).name() + ChatColor.GOLD + " team!");
			}
			else
			{
				Main.SendMsg((Player)ev.getWhoClicked(), ChatColor.RED + "You already have team!");
			}
			
			
			ev.getView().close();
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
			return;
		}
	}

	@Override
	public void UpdateTick()
	{
		
	}
}
