package an0nym8us.positron.menu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

import org.apache.commons.lang.ArrayUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

import an0nym8us.blitz.utils.BlitzUtils;
import an0nym8us.positron.Main;
import an0nym8us.positron.gamemode.PPlayer;
import an0nym8us.positron.gamemode.Speciality;
import an0nym8us.positron.listeners.ManagementListener;
import an0nym8us.utils.menu.DynamicMenu;
import an0nym8us.utils.menu.Menu;

public class ChangeSpecialityMenu extends DynamicMenu {

	public static final ItemStack openItem = new ItemStack(Material.GHAST_TEAR);
	
	static
	{
		ItemMeta im = openItem.getItemMeta();
		im.setDisplayName(ChatColor.LIGHT_PURPLE + "Choose class");
		im.addEnchant(Enchantment.SILK_TOUCH, 1, true);
		im.removeEnchant(Enchantment.SILK_TOUCH);
		List<String> lore = new ArrayList<String>();
		lore.add(ManagementListener.SOULBOUND);
		im.setLore(lore);
		openItem.setItemMeta(im);
	}
	
	public ChangeSpecialityMenu() throws NoSuchMethodException, SecurityException
	{
		super(27, ChatColor.DARK_GREEN + "Choose profession");
		
		for(int i = 0; i < Speciality.values().length; i++)
		{
			SetSlot(Speciality.values()[i].symbol, i);
		}
		
		for(int i = 0; i < size; i++)
		{
			if(itemStacks[i] != null)
			{
				actions.put(i, this.getClass().getMethod("ClickEH", Menu.class, InventoryClickEvent.class));
			}
		}
	}
	
	@EventHandler
	public void onPlayerInteract(PlayerInteractEvent ev)
	{
		try
		{
			if(ev.getItem().equals(openItem))
			{
				ev.getPlayer().openInventory(this.CreateInventory(ev.getPlayer().getUniqueId()));
			}
		}
		catch(Exception ex)
		{
			return;
		}
	}
	
	public void ClickEH(Menu menu, InventoryClickEvent ev)
	{
		for(int i = 0; i < Speciality.values().length; i++)
		{
			if(ev.getCurrentItem().getType().equals(Speciality.values()[i].symbol.getType()) && ev.getCurrentItem().getDurability() == Speciality.values()[i].symbol.getDurability())
			{
				if(Main.arena.GetPPlayer(ev.getWhoClicked().getUniqueId()).SetSpeciality(Speciality.values()[i]))
				{
					ev.getWhoClicked().setHealth(0);
				}
				
				return;
			}
		}
	}
	
	@Override
	public void OpenMenu(UUID uuid)
	{
		Inventory inv = CreateInventory(uuid);
		
		for(int i = 0; i < inv.getSize(); i++)
		{
			ItemStack is = inv.getItem(i); if(is == null) { continue; }
			ItemMeta im = is.getItemMeta();
			
			List<String> lore = im.getLore();
			lore.add("-------------");
			
			if(PPlayer.IsSpecialityAvailable(uuid, (short) Speciality.GetSpecialityBySymbol(inv.getItem(i)).id))
			{
				lore.add(ChatColor.GREEN + "UNLOCKED");
			}
			else
			{
				lore.add(ChatColor.RED + "LOCKED");
			}
			
			im.setLore(lore);
			is.setItemMeta(im);
			
			inv.setItem(i, is);
		}
		
		Bukkit.getPlayer(uuid).openInventory(inv);
	}
}
