package an0nym8us.positron.listeners;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Map.Entry;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;

import an0nym8us.positron.Main;
import an0nym8us.positron.timers.CountdownTimer;
import an0nym8us.positron.timers.ResourceRespawnTimer;

public class ResourceRespawnListener extends ArenaListener {

	public enum ReType
	{
		CoalOre(Material.COAL_ORE, 17500, 2, 3),
		IronOre(Material.IRON_ORE, 17500, 4, 5),
		GoldOre(Material.GOLD_ORE, 17500, 6, 7),
		LapisOre(Material.LAPIS_ORE, 17500, 6, 7),
		RedstoneOre(Material.REDSTONE_ORE, 17500, 5, 7),		
		DiamondOre(Material.DIAMOND_ORE, 17500, 7, 9),
		EmeraldOre(Material.EMERALD_ORE, 17500, 9, 11),
		Gravel(Material.GRAVEL, 12500, 1, 1),
		Sand(Material.SAND, 12500, 1, 1),
		Log(Material.LOG, 15000, 1, 1),
		Log2(Material.LOG_2, 15000, 1, 1),
		Melon(Material.MELON_BLOCK, 15000, 1, 1),
		Wheat(Material.CROPS, 6000, 1, 1),
		Carrots(Material.CARROT, 6000, 1, 1),
		Potatoes(Material.POTATO, 6000, 1, 1);
		
		Material material;
		int duration;
		int minXp;
		int maxXp;
		
		ReType(Material mat, int dur, int min, int max)
		{
			this.material = mat;
			this.duration = dur;
			this.minXp = min;
			this.maxXp = max;
		}
		
		public static boolean CheckType(Material material)
		{
			for(ReType r : ReType.values())
			{
				if(r.material.equals(material))
				{
					return true;
				}
			}
			
			return false;
		}
		
		public static ReType GetByMat(Material material)
		{
			for(ReType r : ReType.values())
			{
				if(r.material.equals(material))
				{
					return r;
				}
			}
			
			return null;
		}
		
		public int GetXP()
		{
			Random r = new Random();
			return minXp + r.nextInt(maxXp - minXp + 1);
		}
	}
	public class Wrapper
	{
		public int delay;
		public Material type;
		
		public Wrapper(int delay, Material type)
		{
			this.delay = delay;
			this.type = type;
		}
	}
	
	int duration;	
	long pauseTime;
	Timer timer;
	
	public HashMap<Location, Wrapper> list;
	
	public ResourceRespawnListener(int arenaID) {
		super(arenaID);
		
		duration = 15000;
		pauseTime = 50;
		
		list = new  HashMap<Location, Wrapper>();
		
		ActiveRRTask();
	}
	
	@EventHandler
	public void onBlockPlace(BlockPlaceEvent ev)
	{
		if(GetArena().ContainsPlayer(ev.getPlayer().getUniqueId()))
		{
			if(ReType.CheckType(ev.getBlock().getType()))
			{
				ev.setCancelled(true);
			}
		}
	}
	
	void ActiveRRTask()
	{
		timer = new Timer();
		
			timer.schedule(new TimerTask()
			{
				@Override
				public void run()
				{
					Iterator<Entry<Location, ResourceRespawnListener.Wrapper>> i = Main.arena.rrL.list.entrySet().iterator();				
					
					while(i.hasNext())
					{
						try
						{
							final Entry<Location, ResourceRespawnListener.Wrapper> e = i.next();
						
							if(e.getValue().delay <= 0)
							{				
								Bukkit.getScheduler().scheduleSyncDelayedTask(Main.main, new Runnable()
								{
									@Override
									public void run()
									{
										e.getKey().getBlock().setType(e.getValue().type);
									}
								}, 1);
								
								i.remove();
							}
							else
							{
								Main.arena.rrL.list.get(e.getKey()).delay -= pauseTime;
							}
						}
						catch(Exception ex)
						{
							Bukkit.getServer().getLogger().info("ConcurrentModificationError");
						}
					}
				}
			}, pauseTime, pauseTime);
	}

	@EventHandler(priority=EventPriority.HIGH)
	public void onBlockBreak(BlockBreakEvent ev)
	{
		if(ev.isCancelled()) { return; }
		
		if(CheckValidation(ev.getPlayer().getUniqueId()))
		{
			if(!ReType.CheckType(ev.getBlock().getType())) { return; }
			
			for(ItemStack i : ev.getBlock().getDrops())
			{
				ev.getPlayer().getInventory().addItem(i);
			}
			
			if(ReType.CheckType(ev.getBlock().getType()))
			{
				list.put(ev.getBlock().getLocation(), new Wrapper(duration, ev.getBlock().getType()));
				ev.setExpToDrop(0);
				
				ev.getPlayer().giveExp(ReType.GetByMat(ev.getBlock().getType()).GetXP());
			}
			
			
			ev.getBlock().setType(Material.AIR);
		}
	}
	
	@EventHandler(priority=EventPriority.NORMAL)
	public void onBlockBreak_2(BlockBreakEvent ev)
	{
		if(GetArena().GetPhase().ID < 3 && ev.getBlock().getType().equals(Material.DIAMOND_ORE))
		{
			ev.setCancelled(true);
		}
	}
}
