package an0nym8us.positron.listeners;

import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;

import an0nym8us.positron.gamemode.Nexus;
import an0nym8us.utils.Main;

public class NexusRegionDefListener extends ArenaListener
{
	public static final int XZ_RADIUS = 12;
	
	public NexusRegionDefListener(int arenaID)
	{
		super(arenaID);
	}

	@EventHandler(priority=EventPriority.HIGH)
	public void onBlockPlace(BlockPlaceEvent ev)
	{
		for(Nexus nexus : GetArena().nexuses)
		{
			if(ev.getBlock().getLocation().getBlockX() < nexus.location.getBlockX() + XZ_RADIUS && ev.getBlock().getLocation().getBlockX() > nexus.location.getBlockX() - XZ_RADIUS && ev.getBlock().getLocation().getBlockZ() < nexus.location.getBlockZ() + XZ_RADIUS && ev.getBlock().getLocation().getBlockZ() > nexus.location.getBlockZ() - XZ_RADIUS)
			{
				ev.setCancelled(true);
				SendWarn(ev.getPlayer());
				
				break;
			}
		}
	}
	
	@EventHandler(priority=EventPriority.NORMAL)
	public void onBlockBreak(BlockBreakEvent ev)
	{		
		if(ev.isCancelled()) { return; }
		
		for(Nexus nexus : GetArena().nexuses)
		{
			if(ev.getBlock().getLocation().getBlockX() < nexus.location.getBlockX() + XZ_RADIUS && ev.getBlock().getLocation().getBlockX() > nexus.location.getBlockX() - XZ_RADIUS && ev.getBlock().getLocation().getBlockZ() < nexus.location.getBlockZ() + XZ_RADIUS && ev.getBlock().getLocation().getBlockZ() > nexus.location.getBlockZ() - XZ_RADIUS)
			{
				ev.setCancelled(true);
				SendWarn(ev.getPlayer());
				
				break;
			}
		}
	}
	
	/*@EventHandler(priority=EventPriority.LOW)
	public void onPlayerInteract(PlayerInteractEvent ev)
	{
		if(ev.getClickedBlock() == null) { return; }
		
		for(Nexus nexus : GetArena().nexuses)
		{
			if(ev.getClickedBlock().getLocation().getBlockX() < nexus.location.getBlockX() + XZ_RADIUS && ev.getClickedBlock().getLocation().getBlockX() > nexus.location.getBlockX() - XZ_RADIUS && ev.getClickedBlock().getLocation().getBlockZ() < nexus.location.getBlockZ() + XZ_RADIUS && ev.getClickedBlock().getLocation().getBlockZ() > nexus.location.getBlockZ() - XZ_RADIUS)
			{
				ev.setCancelled(true);
				
				break;
			}
		}
	}*/
	
	void SendWarn(Player player)
	{
		an0nym8us.positron.Main.SendMsg(player, ChatColor.DARK_RED + "Nie mozesz tutaj budowac!");
	}
}
