package an0nym8us.positron.listeners;

import java.util.Random;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.potion.PotionEffectType;

import com.comphenix.packetwrapper.WrapperPlayServerNamedSoundEffect;
import com.comphenix.packetwrapper.WrapperPlayServerNamedSoundEffect.NamedSoundEffects;

import an0nym8us.positron.Main;
import an0nym8us.positron.gamemode.Arena.Phase;
import an0nym8us.positron.gamemode.Arena.Team;
import an0nym8us.positron.gamemode.Nexus;
import an0nym8us.positron.gamemode.PPlayer;
import an0nym8us.positron.gamemode.nexus.GameWonEvent;
import an0nym8us.positron.gamemode.nexus.NexusCapturedEvent;
import an0nym8us.positron.gamemode.nexus.NexusDamagedEvent;
import an0nym8us.positron.gamemode.nexus.NexusHealedEvent;
import an0nym8us.positron.gamemode.nexus.TeamDestroyedEvent;

public class NexusListener extends ArenaListener {

	public NexusListener(int arenaID) {
		super(arenaID);
		// TODO Auto-generated constructor stub
	}

	@EventHandler
	public void onNexusDamaged(NexusDamagedEvent ev)
	{
		GetArena().sm.UpdateScores();
		ev.nexus.location.getWorld().playSound(ev.nexus.location, Sound.ANVIL_LAND, 1000, new Random().nextFloat());
		
		Bukkit.getServer().broadcastMessage(ChatColor.GRAY + "Player " + ev.GetPlayer().getDisplayName() + ChatColor.GRAY + " damaged " + ev.nexus.team.chatColor + ev.nexus.team.name + ChatColor.GRAY + "'s nexus!");
	}
	
	@EventHandler
	public void onNexusHealed(NexusHealedEvent ev)
	{
		GetArena().sm.UpdateScores();
	}
	
	@EventHandler
	public void onTeamDestroyed(TeamDestroyedEvent ev)
	{
		GetArena().sm.UpdateScores();
		SendTeamDeath(ev.team);
		
		if(CheckIfWon())
		{
			Bukkit.getServer().getPluginManager().callEvent(new GameWonEvent());
		}
	}
	
	@EventHandler
	public void onGameWon(GameWonEvent ev)
	{
		GetArena().sm.UpdateScores();
		
		for(PPlayer p : GetArena().players)
		{
			SendBoom(p.GetPlayer());
			Main.SendMsg(p.GetPlayer(), ChatColor.YELLOW + "Game has just finished!");
		}
				
		GetArena().FinishGame();
	}
	
	@EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
	public void onBlockBreak(BlockBreakEvent ev)
	{
		for(Nexus n : GetArena().nexuses)
		{
			if(n.location.equals(ev.getBlock().getLocation()) && !GetArena().GetPlayerTeam(ev.getPlayer().getUniqueId()).equals(n.team) && !ev.getPlayer().hasPotionEffect(PotionEffectType.INVISIBILITY))
			{
				n.DamageNexus(Main.arena.GetPhase().equals(Phase.Phase5) ? 2 : 1, GetArena().GetPlayerTeam(ev.getPlayer().getUniqueId()), ev.getPlayer().getUniqueId());
				ev.setCancelled(true);
			}
		}
	}
	
	public boolean CheckIfWon()
	{
		boolean is = false;
		
		for(Nexus n : GetArena().nexuses)
		{
			if(!n.IsDestroyed())
			{
				if(is) { return false; }
				
				is = true;
			}
		}
		
		return true;
	}
	
	public void SendTeamDeath(Team team)
	{
		for(PPlayer p : GetArena().players)
		{
			SendBoom(p.GetPlayer());
			Main.SendMsg(p.GetPlayer(), team.chatColor + team.name + ChatColor.WHITE + " team has been destroyed!");
		}
	}
	
	void SendBoom(Player p)
	{
		WrapperPlayServerNamedSoundEffect wp = new WrapperPlayServerNamedSoundEffect();
		wp.setEffectPositionX(p.getLocation().getX());
		wp.setEffectPositionY(p.getLocation().getY());
		wp.setEffectPositionZ(p.getLocation().getZ());
		wp.setSoundName(NamedSoundEffects.RANDOM_EXPLODE);		
		wp.setPitch(1);
		wp.setVolume(50);
		
		wp.sendPacket(p);
	}
}
