package an0nym8us.positron.listeners;

import java.util.List;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryInteractEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;

import com.comphenix.packetwrapper.WrapperPlayServerEntityTeleport;
import com.comphenix.packetwrapper.WrapperPlayServerNamedEntitySpawn;
import com.comphenix.packetwrapper.WrapperPlayServerSpawnEntityLiving;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;

import an0nym8us.blitz.utils.BlitzUtils;
import an0nym8us.blitz.utils.userData.ServerRank;
import an0nym8us.positron.Main;
import an0nym8us.positron.gamemode.PPlayer;
import an0nym8us.positron.gamemode.Speciality;
import an0nym8us.positron.gamemode.Arena.Phase;
import an0nym8us.positron.gamemode.Arena.Team;
import an0nym8us.positron.gamemode.events.PhaseChangedEvent;
import an0nym8us.positron.gamemode.events.PlayerOfflineEvent;
import an0nym8us.positron.gamemode.events.PlayerOnlineEvent;
import an0nym8us.utils.ConsoleColor;

public class ManagementListener extends ArenaListener {

	public static final String SOULBOUND = ChatColor.GOLD + "Soulbound";
	
	public ManagementListener(int arenaID) {
		super(arenaID);
	}
	
	@EventHandler
	public void onPlayerJoin(PlayerJoinEvent ev)
	{
		if(Bukkit.getServer().getOnlinePlayers().length >= Bukkit.getServer().getMaxPlayers() - Main.RESERVED_SLOTS && BlitzUtils.instance.GetUser(ev.getPlayer().getUniqueId()).rank.equals(ServerRank.GetByName("Default")))
		{
			ev.getPlayer().kickPlayer("Server is full!");
		}
		else
		{
			Main.arena.sm.SetScoreboard(ev.getPlayer());
		}
	}
	
	@EventHandler
	public void onPlayerJoin_2(PlayerJoinEvent ev)
	{		
		if(!GetArena().ContainsPlayer(ev.getPlayer().getUniqueId()))
		{
			GetArena().AddPlayer(ev.getPlayer().getUniqueId());
			Bukkit.getServer().getPluginManager().callEvent(new PlayerOnlineEvent(ev.getPlayer().getUniqueId(), ev.getPlayer().getName(), arenaID));
		}
			
		GetArena().TpPlayerToArena(ev.getPlayer().getUniqueId());
	}
	
	@EventHandler
	public void onPlayerRespawn(final PlayerRespawnEvent ev)
	{
		if(GetArena().ContainsPlayer(ev.getPlayer().getUniqueId()))
		{
			if(GetArena().IsTeamDestroyed(GetArena().GetPlayerTeam(ev.getPlayer().getUniqueId())))
			{
				Bukkit.getScheduler().runTaskLater(Main.main, new Runnable()
				{
					@Override
					public void run()
					{
						ev.getPlayer().teleport(GetArena().preWorld.getSpawnLocation());
						GetArena().TpPlayerToArena(ev.getPlayer().getUniqueId());
					}
				}, 1L);
				
				return;
			}
				
			Bukkit.getScheduler().runTaskLater(Main.main, new Runnable()
			{
				@Override
				public void run()
				{
					GetArena().GetPPlayer(ev.getPlayer().getUniqueId()).Refresh();
					GetArena().TpPlayerToArena(ev.getPlayer().getUniqueId());
				}
			}, 1L);
		}
		else
		{
			GetArena().AddPlayer(ev.getPlayer().getUniqueId());
			GetArena().TpPlayerToArena(ev.getPlayer().getUniqueId());
		}
	}
	
	@EventHandler
	public void onPlayerQuit(PlayerQuitEvent ev)
	{
		Bukkit.getServer().getPluginManager().callEvent(new PlayerOfflineEvent(ev.getPlayer().getUniqueId(), ev.getPlayer().getName(), arenaID));
	}
	
	@EventHandler
	public void onPlayerOnline(PlayerOnlineEvent ev)
	{
		if(ev.arenaID != arenaID) { return; }
		
		Bukkit.getServer().getLogger().info(ev.name + "" + ConsoleColor.GREEN + " is online!" + " - " + arenaID + "" + ConsoleColor.RESET);
	}
	
	@EventHandler
	public void onPlayerOffline(PlayerOfflineEvent ev)
	{
		if(ev.arenaID != arenaID) { return; }
		
		Bukkit.getServer().getLogger().info(ev.name + "" + ConsoleColor.RED + " is offline!" + " - " + arenaID + "" + ConsoleColor.RESET);
	}
	
	@EventHandler
	public void onPhaseChanged(PhaseChangedEvent ev)
	{
		if(ev.newPhase == Phase.Phase1)
		{
			for(PPlayer p : GetArena().players)
			{
				if(!p.GetTeam().equals(Team.Null))
				{
					Bukkit.getPlayer(p.GetUUID()).teleport(GetArena().GetRandomSpawnLoc(p.GetTeam()));
					p.Refresh();
				}
			}
		}
		else if(ev.newPhase == Phase.Closed)
		{
			Main.main.CloseArena();
		}
	}
	
	// SOULBOUND-HANDLING HANDLE
	@EventHandler
	public void onItemSpawn(final ItemSpawnEvent ev)
	{
		if(!GetArena().CheckValidation(ev.getEntity().getLocation())) { return; }		
		if(ev.getEntity().getItemStack() == null || ev.getEntity().getItemStack().getItemMeta() == null || ev.getEntity().getItemStack().getItemMeta().getLore() == null) { return; }
		
		List<String> lore = ev.getEntity().getItemStack().getItemMeta().getLore();
		
		for(String s : lore)
		{
			if(s.equals(SOULBOUND))
			{
				//get.playEffect(ev.getEntity().getLocation(), Effect.ZOMBIE_CHEW_IRON_DOOR, 0);
				ev.setCancelled(true);
			}
		}
	}
	
	@EventHandler(priority=EventPriority.LOWEST)
	public void onInventoryClick(InventoryClickEvent ev)
	{		
		if(!GetArena().ContainsPlayer(ev.getWhoClicked().getUniqueId())) { return; }		
		if(ev.getCurrentItem() == null || ev.getCurrentItem().getItemMeta() == null || ev.getCurrentItem().getItemMeta().getLore() == null) { return; }
		
		if(!(ev.getInventory().getType().equals(InventoryType.CRAFTING)))
		{
			List<String> lore = ev.getCurrentItem().getItemMeta().getLore();
			
			for(String s : lore)
			{
				if(s.equals(SOULBOUND))
				{
					ev.setCancelled(true);
				}
			}
		}
		else if (ev.getRawSlot() < 5)
		{
			List<String> lore = ev.getCurrentItem().getItemMeta().getLore();
			
			for(String s : lore)
			{
				if(s.equals(SOULBOUND))
				{
					ev.setCancelled(true);
				}
			}
		}
	}
	
	@EventHandler(priority=EventPriority.LOWEST)
	public void onInventoryDrag(InventoryDragEvent ev)
	{
		if(!GetArena().ContainsPlayer(ev.getWhoClicked().getUniqueId())) { return; }		
		if(ev.getCursor() == null || ev.getCursor().getItemMeta() == null || ev.getCursor().getItemMeta().getLore() == null) { return; }
		
		if(!(ev.getInventory().getType().equals(InventoryType.PLAYER)))
		{
			List<String> lore = ev.getCursor().getItemMeta().getLore();
			
			for(String s : lore)
			{
				if(s.equals(SOULBOUND))
				{
					ev.setCancelled(true);
				}
			}
		}
	}
	
	@EventHandler
	public void onPlayerDeath(PlayerDeathEvent ev)
	{
		if(ev.getEntity().getKiller() != null)
		{
			ev.setDeathMessage(ChatColor.GRAY + "Player " + GetArena().GetPlayerTeam(ev.getEntity().getUniqueId()).chatColor + ev.getEntity().getName() + ChatColor.GRAY + " has been slain by " + GetArena().GetPlayerTeam(ev.getEntity().getKiller().getUniqueId()).chatColor + ev.getEntity().getKiller().getName() + ChatColor.GRAY + "!");
		}
		else
		{
			ev.setDeathMessage(ChatColor.GRAY + "Player " + GetArena().GetPlayerTeam(ev.getEntity().getUniqueId()).chatColor + ev.getEntity().getName() + ChatColor.GRAY + " died.");
		}
	}
}
