package an0nym8us.positron.listeners;

import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class InfinityEnchListener extends ArenaListener {

	public InfinityEnchListener(int arenaID) {
		super(arenaID);
		// TODO Auto-generated constructor stub
	}

	@EventHandler
	public void onPlayerInteract(PlayerInteractEvent ev)
	{
		if(ev.getItem() == null) { return; }
		
		if(ev.getItem().containsEnchantment(Enchantment.ARROW_INFINITE) && ev.getItem().getEnchantmentLevel(Enchantment.ARROW_INFINITE) == 2)
		{
			ev.getItem().setDurability((short) -1);
		}
	}
	
	@EventHandler
	public void onPlayerInteractEntity(PlayerInteractEntityEvent ev)
	{
		if(ev.getPlayer().getItemInHand() == null) { return; }
		
		if(ev.getPlayer().getItemInHand().containsEnchantment(Enchantment.ARROW_INFINITE) && ev.getPlayer().getItemInHand().getEnchantmentLevel(Enchantment.ARROW_INFINITE) == 2)
		{
			ev.getPlayer().getItemInHand().setDurability((short) -1);
		}
	}
	
	@EventHandler
	public void onBlockBreak(BlockBreakEvent ev)
	{
		if(ev.getPlayer().getItemInHand() == null) { return; }
		
		if(ev.getPlayer().getItemInHand().containsEnchantment(Enchantment.ARROW_INFINITE) && ev.getPlayer().getItemInHand().getEnchantmentLevel(Enchantment.ARROW_INFINITE) == 2)
		{
			ev.getPlayer().getItemInHand().setDurability((short) -1);
		}
	}
	
	@EventHandler
	public void onPlayerDropItem(PlayerDropItemEvent ev)
	{
		if(ev.getItemDrop().getItemStack() == null) { return; }
		
		if(ev.getItemDrop().getItemStack().containsEnchantment(Enchantment.ARROW_INFINITE) && ev.getItemDrop().getItemStack().getEnchantmentLevel(Enchantment.ARROW_INFINITE) == 2)
		{
			ev.getItemDrop().getItemStack().removeEnchantment(Enchantment.ARROW_INFINITE);
		}
	}
}
