package an0nym8us.positron.listeners;

import java.util.UUID;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.AsyncPlayerChatEvent;

import an0nym8us.blitz.utils.BlitzUtils;
import an0nym8us.blitz.utils.userData.ServerRank;
import an0nym8us.positron.Main;
import an0nym8us.positron.gamemode.Arena.Team;

public class ChatChannelListener extends ArenaListener
{
	public static final String GLOBAL_CHAT = "GLOB";
	public static final String TEAM_CHAT = "TEAM";
	
	public ChatChannelListener(int arenaID)
	{
		super(arenaID);
	}

	@EventHandler(priority=EventPriority.HIGH)
	public void onAsyncPlayerChat(AsyncPlayerChatEvent ev)
	{
		ev.setCancelled(true);
		
		if(ev.getMessage().startsWith("!") || Main.arena.GetPlayerTeam(ev.getPlayer().getUniqueId()).equals(Team.Null))
		{
			for(Player p : Bukkit.getOnlinePlayers())
			{
				p.sendMessage(GetMessage(ev.getPlayer().getUniqueId(), GLOBAL_CHAT, ev.getMessage().replaceFirst("!", "")));
			}
			
			Bukkit.getConsoleSender().sendMessage(GetMessage(ev.getPlayer().getUniqueId(), GLOBAL_CHAT, ev.getMessage().replaceFirst("!", "")));
		}
		else
		{
			for(Player p : Bukkit.getOnlinePlayers())
			{
				if(GetArena().GetPlayerTeam(p.getUniqueId()).equals(GetArena().GetPlayerTeam(ev.getPlayer().getUniqueId())))
				{
					p.sendMessage(GetMessage(ev.getPlayer().getUniqueId(), TEAM_CHAT, ev.getMessage()));
				}
			}
			
			Bukkit.getConsoleSender().sendMessage(GetMessage(ev.getPlayer().getUniqueId(), TEAM_CHAT, ev.getMessage()));
		}
	}
	
	String GetMessage(UUID uuid, String channel, String msg)
	{
		return (channel.equals(GLOBAL_CHAT) ? "" : ChatColor.DARK_GRAY + "[" + channel + "] ") + ChatColor.GRAY + "[" +  Main.arena.GetPPlayer(uuid).GetTeam().chatColor + Main.arena.GetPPlayer(uuid).GetTeam().name + ChatColor.GRAY + "] " + (BlitzUtils.instance.GetUser(uuid).GetCurrentRank().sc.equals("") ? "" : BlitzUtils.instance.GetUser(uuid).GetCurrentRank().chatColor + "[" + BlitzUtils.instance.GetUser(uuid).GetCurrentRank().sc + "] ") + Bukkit.getPlayer(uuid).getName() + ChatColor.DARK_GRAY + " >> " + ChatColor.GRAY + msg;
	}
}
