package an0nym8us.positron.listeners;

import java.util.UUID;

import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.PlayerDeathEvent;

import an0nym8us.blitz.utils.BlitzUtils;
import an0nym8us.positron.gamemode.Arena.Team;
import an0nym8us.positron.gamemode.Nexus;
import an0nym8us.positron.gamemode.nexus.GameWonEvent;
import an0nym8us.positron.gamemode.nexus.NexusCapturedEvent;
import an0nym8us.positron.gamemode.nexus.NexusDamagedEvent;
import an0nym8us.positron.gamemode.nexus.TeamDestroyedEvent;

public class BlitzXpListener extends ArenaListener
{
	public BlitzXpListener(int arenaID)
	{
		super(arenaID);
	}
	
	@EventHandler
	public void onPlayerDeath(PlayerDeathEvent ev)
	{
		if(ev.getEntity() instanceof Player)
		{
			Player p = (Player)ev.getEntity();
			
			if(p.getKiller() != null)
			{
				BlitzUtils.instance.AddXp(p.getKiller().getUniqueId(), 4);
				BlitzUtils.instance.AddXp(p.getUniqueId(), -1);
			}
		}
	}
	
	@EventHandler
	public void onNexusDamaged(NexusDamagedEvent ev)
	{
		for(UUID uuid : GetArena().GetPlayers())
		{
			if(GetArena().GetPPlayer(uuid).GetTeam().equals(ev.damager))
			{
				BlitzUtils.instance.AddXp(uuid, ev.damage);
			}
		}
	}
	
	@EventHandler
	public void onTeamDestroyed(TeamDestroyedEvent ev)
	{
		for(UUID uuid : GetArena().GetPlayers())
		{
			if(GetArena().GetPPlayer(uuid).GetTeam().equals(ev.team))
			{
				BlitzUtils.instance.AddXp(uuid, 40);
			}
		}
	}
	
	@EventHandler
	public void onGameWon(GameWonEvent ev)
	{
		Team alived = null;
		
		for(Nexus n : GetArena().nexuses)
		{
			if(!n.IsDestroyed())
			{
				for(UUID uuid : GetArena().GetPlayers())
				{
					if(GetArena().GetPPlayer(uuid).GetTeam().equals(n.team))
					{
						BlitzUtils.instance.AddXp(uuid, 150);
					}
				}
			}
		}
	}
}
