package an0nym8us.positron.gamemode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;

import an0nym8us.positron.Main;
import an0nym8us.positron.gamemode.Arena.Team;
import an0nym8us.positron.speciality.DefaultListener;
import an0nym8us.positron.speciality.DemomanListener;
import an0nym8us.positron.speciality.EnchanterListener;
import an0nym8us.positron.speciality.EngineerListener;
import an0nym8us.positron.speciality.MinerListener;
import an0nym8us.positron.speciality.OpListener;
import an0nym8us.positron.speciality.ScoutListener;
import an0nym8us.positron.speciality.SmelterListener;
import an0nym8us.positron.speciality.SpecialityListener;
import an0nym8us.positron.speciality.TankListener;

public enum Speciality
{	
	Default(0, "Civilian", "Fight as civilian in battles of your team! You do not own any special things, but it's not an obstacle to develop and buy one of other kits!", DefaultListener.class,
			new ItemStack(Material.WORKBENCH, 1),
			new ItemStack(Material.LEATHER_HELMET, 1),
			new ItemStack(Material.LEATHER_CHESTPLATE, 1),
			new ItemStack(Material.LEATHER_LEGGINGS, 1),
			new ItemStack(Material.LEATHER_BOOTS, 1),
			new ItemStack(Material.WOOD_SWORD, 1),
			new ItemStack(Material.WOOD_PICKAXE, 1),
			new ItemStack(Material.WOOD_SPADE, 1),
			new ItemStack(Material.WOOD_AXE, 1)),
	Scout(1, "Scout", "Use your speed multiplier and run, do the reconnaissance, avoid damage and get huge advantage for your team! Use your grapple, which is significantly increasing your movement speed.", ScoutListener.class,
			new ItemStack(Material.FISHING_ROD, 1),
			new ItemStack(Material.LEATHER_HELMET, 1),
			new ItemStack(Material.LEATHER_CHESTPLATE, 1),
			new ItemStack(Material.LEATHER_LEGGINGS, 1),
			new ItemStack(Material.LEATHER_BOOTS, 1),
			new ItemStack(Material.FISHING_ROD, 1),
			new ItemStack(Material.WOOD_SWORD, 1),
			new ItemStack(Material.WOOD_PICKAXE, 1),
			new ItemStack(Material.WOOD_AXE, 1)),
	Miner(2, "Miner", "Use your mining sense and get twice more ores! You get stone pickaxe at start, which lets you to start mining immediately!", MinerListener.class,
			new ItemStack(Material.IRON_PICKAXE, 1),
			new ItemStack(Material.LEATHER_HELMET, 1),
			new ItemStack(Material.LEATHER_CHESTPLATE, 1),
			new ItemStack(Material.LEATHER_LEGGINGS, 1),
			new ItemStack(Material.LEATHER_BOOTS, 1),
			new ItemStack(Material.STONE_PICKAXE, 1),
			new ItemStack(Material.WOOD_SWORD, 1),
			new ItemStack(Material.WOOD_PICKAXE, 1),
			new ItemStack(Material.WOOD_AXE, 1)),
	Enchanter(3, "Enchanter", "Your unusual ability allows you to get 40% more experience. Use it to quickly provide yourself and your team with the best Items!", EnchanterListener.class,
			new ItemStack(Material.EXP_BOTTLE, 1),
			new ItemStack(Material.LEATHER_HELMET, 1),
			new ItemStack(Material.LEATHER_CHESTPLATE, 1),
			new ItemStack(Material.LEATHER_LEGGINGS, 1),
			new ItemStack(Material.LEATHER_BOOTS, 1),
			new ItemStack(Material.GOLD_SWORD, 1),
			new ItemStack(Material.WOOD_SWORD, 1),
			new ItemStack(Material.WOOD_PICKAXE, 1),
			new ItemStack(Material.WOOD_AXE, 1)),
	Engineer(4, "Engineer", "Use your abilities and help your team on the battlefield with special devices!", EngineerListener.class,
			new ItemStack(137, 1),
			new ItemStack(Material.LEATHER_HELMET, 1),
			new ItemStack(Material.LEATHER_CHESTPLATE, 1),
			new ItemStack(Material.LEATHER_LEGGINGS, 1),
			new ItemStack(Material.LEATHER_BOOTS, 1),
			new ItemStack(Material.STONE_SWORD, 1),
			new ItemStack(Material.WOOD_PICKAXE, 1),
			new ItemStack(Material.WOOD_AXE, 1),
			new ItemStack(Material.REDSTONE_BLOCK, 1),
			new ItemStack(Material.QUARTZ_BLOCK, 1),
			new ItemStack(Material.STONE_PLATE, 2)),
	Tank(5, "Tank", "You are a tank. Use your increased defense abilities to fight!", TankListener.class,
			new ItemStack(Material.OBSIDIAN, 1),
			new ItemStack(Material.IRON_HELMET),
			new ItemStack(Material.LEATHER_CHESTPLATE),
			new ItemStack(Material.LEATHER_LEGGINGS),
			new ItemStack(Material.LEATHER_BOOTS),
			new ItemStack(Material.IRON_SWORD, 1),
			new ItemStack(Material.WOOD_PICKAXE, 1),
			new ItemStack(Material.WOOD_AXE, 1)),
	Demoman(6, "Demoman", "You are a bomb. Use your nuke to break everything and everybody! You are spawning with nuke!", DemomanListener.class,
			new ItemStack(Material.TNT, 1),
			new ItemStack(Material.LEATHER_HELMET, 1),
			new ItemStack(Material.LEATHER_CHESTPLATE, 1),
			new ItemStack(Material.LEATHER_LEGGINGS, 1),
			new ItemStack(Material.LEATHER_BOOTS, 1),
			new ItemStack(Material.WOOD_SWORD, 1),
			new ItemStack(Material.WOOD_PICKAXE, 1),
			new ItemStack(Material.WOOD_AXE, 1),
			DemomanListener.GetNuke()),
	Smelter(7, "Smelter", "You are the coal. Smelt everything faster by 25%! You also have a 33,(3)% chance to get ingot instead of ore while mining!", SmelterListener.class,
			new ItemStack(Material.COAL, 1),
			new ItemStack(Material.LEATHER_HELMET, 1),
			new ItemStack(Material.LEATHER_CHESTPLATE, 1),
			new ItemStack(Material.LEATHER_LEGGINGS, 1),
			new ItemStack(Material.LEATHER_BOOTS, 1),
			new ItemStack(Material.WOOD_SWORD, 1),
			new ItemStack(Material.WOOD_PICKAXE, 1),
			new ItemStack(Material.WOOD_AXE, 1),
			new ItemStack(Material.WOOD_SPADE)),
	Op(666, "Op", "Op test kit - FOR ADMINS ONLY", OpListener.class,
			new ItemStack(Material.GOLDEN_APPLE, 1, (short)1),
			new ItemStack(Material.IRON_HELMET, 1),
			new ItemStack(Material.DIAMOND_CHESTPLATE, 1),
			new ItemStack(Material.IRON_LEGGINGS, 1),
			new ItemStack(Material.IRON_BOOTS, 1),
			new ItemStack(Material.IRON_SWORD, 1),
			new ItemStack(Material.DIAMOND_PICKAXE, 1),
			new ItemStack(Material.DIAMOND_AXE, 1),
			new ItemStack(Material.BAKED_POTATO, 64),
			new ItemStack(Material.GOLDEN_APPLE, 4, (short)1),
			new ItemStack(Material.BOW, 1));
	
	private static final ChatColor DESC_COLOR = ChatColor.YELLOW;
	
	public int id;
	public String name;
	public String[] description;
	public ItemStack symbol;
	ItemStack[] armor;
	ItemStack[] inventory;
	Class<? extends SpecialityListener> listener;
	
	Speciality(int id, String name, String description, Class<? extends SpecialityListener> listener, ItemStack symbol, ItemStack... inv)
	{
		this.id = id;
		this.name = name;
		this.description = FancySplit(description, 25);
		this.listener = listener;
		this.symbol = symbol;
		this.armor = Arrays.copyOfRange(inv,  0, 4);
		this.inventory = Arrays.copyOfRange(inv, 4, inv.length);
		
		ItemMeta meta = symbol.getItemMeta();
		meta.setDisplayName(ChatColor.AQUA + name);		
		meta.setLore(Arrays.asList(this.description));
		symbol.setItemMeta(meta);
	}
	
	public ItemStack[] GetInv()
	{
		ItemStack[] result = new ItemStack[inventory.length];
		
		for(int i = 0; i < result.length; i++)
		{
			result[i] = inventory[i] == null ? null : new ItemStack(inventory[i].getType(), inventory[i].getAmount(), inventory[i].getDurability());
			
			if(inventory[i] != null && inventory[i].getItemMeta() != null)
			{
				result[i].setItemMeta(inventory[i].getItemMeta());
			}
		}
		
		return Main.SetSoulbound(result);
	}
	
	public ItemStack[] GetArmor(Team team)
	{
		ItemStack[] result = new ItemStack[armor.length];
		
		if(team != null)
		{
			for(int i = 0; i < result.length; i++)
			{
				if(armor[i].getType().getId() >= 298 && armor[i].getType().getId() <= 301)
				{
					result[i] = armor[i] == null ? null : new ItemStack(armor[i].getType(), armor[i].getAmount(), armor[i].getDurability());
					LeatherArmorMeta lam = (LeatherArmorMeta) result[i].getItemMeta();
					
					lam.setColor(team.color);
					
					result[i].setItemMeta(lam);
				}
				else
				{
					result[i] = armor[i] == null ? null : new ItemStack(armor[i].getType(), armor[i].getAmount(), armor[i].getDurability());
				}
			}
		}
		else
		{
			for(int i = 0; i < result.length; i++)
			{
				result[i] = new ItemStack(armor[i].getType(), armor[i].getAmount(), armor[i].getDurability());
			}
		}
		
		return Main.SetSoulbound(result);
	}
	
	String[] FancySplit(String text, int minLength)
	{
		String[] data = text.split(" ");
		List<String> result = new ArrayList<String>();
		String buff = new String();
		
		for(int i = 0; i < data.length; i++)
		{
			if(data[i].contains("\n"))
			{
				data[i + 1] = data[i].split("\n")[1] + " " + data[i + 1];
				
				data[i] = data[i].split("\n")[0];
			}
			
			buff += data[i] + " ";
			
			if(buff.length() >= minLength)
			{
				result.add(ChatColor.YELLOW + buff);
				buff = new String();
			}
		}
		
		if(buff.length() != 0)
		{
			result.add(ChatColor.YELLOW + buff);
		}
		
		return result.toArray(new String[result.size()]);
	}
	
	public static Speciality GetSpecialityBySymbol(ItemStack is)
	{
		for(Speciality sp : Speciality.values())
		{
			if(sp.symbol.equals(is))
			{
				return sp;
			}
		}
		
		return null;
	}
	
	public static Speciality GetByID(int id)
	{
		for(Speciality sp : Speciality.values())
		{
			if(sp.id == id)
			{
				return sp;
			}
		}
		
		return null;
	}
}
