package an0nym8us.positron.gamemode;

import org.bukkit.Bukkit;

import an0nym8us.positron.Main;
import an0nym8us.positron.gamemode.Arena.Phase;
import an0nym8us.positron.gamemode.events.PhaseChangedEvent;
import an0nym8us.positron.timers.PhaseTimer;

public class PhaseManager
{
	Phase phase;
	public PhaseTimer phaseTimer;
	int arenaID;
	
	public PhaseManager(int arenaID)
	{
		phaseTimer = new PhaseTimer(arenaID, Phase.Null);
		phase = Phase.Null;
		this.arenaID = arenaID;
	}
	
	public Phase GetPhase()
	{
		return phase;
	}
	
	Arena GetArena()
	{
		return Main.arena;
	}
	
	public void Start()
	{
		phaseTimer.Start();
	}
	
	public Phase NextPhase()
	{
		phase = Phase.GetByID(phase.ID + 1);
		
		Bukkit.getServer().getPluginManager().callEvent(new PhaseChangedEvent(Phase.GetByID(phase.ID - 1), phase, GetArena().arenaID));
		return phase;
	}
	
	public void SetPhase(Phase phase)
	{
		Phase oldPhase = this.phase;
		this.phase = phase;
		
		Bukkit.getServer().getPluginManager().callEvent(new PhaseChangedEvent(oldPhase, phase, GetArena().arenaID));
		phaseTimer.ResetPhaseData();
	}
}
