package an0nym8us.positron.gamemode;

import java.util.Arrays;
import java.util.UUID;

import org.apache.commons.lang.ArrayUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

import an0nym8us.api.events.EventManager;
import an0nym8us.blitz.utils.BlitzUtils;
import an0nym8us.positron.Main;
import an0nym8us.positron.gamemode.Arena.Team;
import an0nym8us.positron.gamemode.events.PlayerOfflineEvent;
import an0nym8us.positron.gamemode.events.PlayerOnlineEvent;
import an0nym8us.positron.gamemode.events.SpecialityChangedEvent;

public class PPlayer
{
	UUID uuid;
	Team team;
	
	Speciality speciality;
	
	int arenaID;
	
	public PPlayer(UUID uuid, Team team, Speciality s, int arenaID)
	{
		this.uuid = uuid;
		this.team = team;
		this.speciality = s;
		this.arenaID = arenaID;
	}
	
	public boolean IsOnline()
	{
		for(Player p : Bukkit.getServer().getOnlinePlayers())
		{
			if(p.getUniqueId().equals(uuid))
			{
				return true;
			}
		}
		
		return false;
	}
	
	public UUID GetUUID()
	{
		return uuid;
	}
	
	public Player GetPlayer()
	{
		return Bukkit.getPlayer(uuid);
	}
	
	public Team GetTeam()
	{
		return team;
	}
	
	public Speciality GetSpeciality()
	{
		return speciality;
	}
	
	public void SetTeam(Team team)
	{
		this.team = team;
	}
	
	public boolean SetSpeciality(Speciality speciality)
	{
		if(IsSpecialityAvailable(speciality))
		{
			Speciality old = this.speciality;
			this.speciality = speciality;
			
			Bukkit.getServer().getPluginManager().callEvent(new SpecialityChangedEvent(arenaID, old, this.speciality, this));
			
			return true;
		}
		else
		{
			Main.SendMsg(Bukkit.getPlayer(uuid), ChatColor.DARK_RED + "Nie odblokowales tej profesji!");
			
			return false;
		}
	}
	
	public void Refresh() // Refreshes speciality features
	{
		Main.ResetPlayerSettings(GetPlayer());
		this.SetEquipment();
		GetArena().GetSLById(this.speciality.id)._preparePlayer(this);
	}
	
	public boolean IsSpecialityAvailable(Speciality spec)
	{
		return IsSpecialityAvailable((short)spec.id);
	}
	public boolean IsSpecialityAvailable(short id)
	{
		return IsSpecialityAvailable(uuid, id);
	}	
	public static boolean IsSpecialityAvailable(UUID uuid, short id)
	{
		return ArrayUtils.contains(BlitzUtils.instance.GetUser(uuid).GetAvailableSpecialities(),id);
	}
	
	public boolean Compare(UUID uuid, Team team)
	{
		return this.uuid.equals(uuid) && this.team.equals(team);
	}
	
	public void SetEquipment()
	{
		Player player = Bukkit.getPlayer(uuid);	
		player.getInventory().clear();
		
		ItemStack[] armor = speciality.GetArmor(team);
		ItemStack[] inventory = speciality.GetInv();
		
		player.getInventory().setHelmet(armor[0]);
		player.getInventory().setChestplate(armor[1]);
		player.getInventory().setLeggings(armor[2]);
		player.getInventory().setBoots(armor[3]);
		
		for(int i = 0; i < inventory.length; i++)
		{
			player.getInventory().setItem(i, inventory[i]);
		}
	}
	
	Arena GetArena()
	{
		return Main.arena;
	}
}
