package an0nym8us.positron.gamemode;

import java.util.UUID;

import org.bukkit.Bukkit;
import org.bukkit.Location;

import an0nym8us.positron.Main;
import an0nym8us.positron.gamemode.Arena.Team;
import an0nym8us.positron.gamemode.nexus.GameWonEvent;
import an0nym8us.positron.gamemode.nexus.NexusCapturedEvent;
import an0nym8us.positron.gamemode.nexus.NexusDamagedEvent;
import an0nym8us.positron.gamemode.nexus.NexusHealedEvent;
import an0nym8us.positron.gamemode.nexus.TeamDestroyedEvent;

public class Nexus
{
	int arenaID;
	public Team team;
	int health;
	public Location location;
	
	boolean destroyed;
	
	public Nexus(int arenaID, Team team, int health, Location location)
	{
		this.arenaID = arenaID;
		this.team = team;
		this.health = health;
		this.location = location;
		
		destroyed = false;
	}
	
	Arena GetArena()
	{
		return Main.arena;
	}
	
	public int GetHealth()
	{
		return health;
	}
	
	public void DamageNexus(int value, Team damager, UUID pDamager)
	{
		if(destroyed) { return; }
		if(GetArena().GetPhase().ID < 2) { return; }
		
		health -= value;
		
		Bukkit.getServer().getPluginManager().callEvent(new NexusDamagedEvent(this, damager, pDamager, value));
		
		if(health <= 0)
		{		
			Bukkit.getServer().getPluginManager().callEvent(new TeamDestroyedEvent(team));
			ChangeTerrain();
			destroyed = true;
			
			if(Main.arena.nL.CheckIfWon())
			{
				Bukkit.getServer().getPluginManager().callEvent(new GameWonEvent());
			}
		}
	}
	
	public boolean IsDestroyed()
	{
		return destroyed;
	}
	
	public void RepairNexus(int value)
	{
		if(destroyed) { return; }
		
		health += value;
		
		Bukkit.getServer().getPluginManager().callEvent(new NexusHealedEvent(this, value));
	}
	
	void ChangeTerrain()
	{
		for(int i = location.getBlockX() - 16; i < location.getBlockX() + 16; i++)
		{
			for(int j = 0; j < 256; j++)
			{
				for(int k = location.getBlockZ() - 16; k < location.getBlockZ() + 16; k++)
				{
					if(new Location(location.getWorld(), i, j, k).getBlock().getType().getId() == 35 || new Location(location.getWorld(), i, j, k).getBlock().getType().getId() == 171 || new Location(location.getWorld(), i, j, k).getBlock().getType().getId() == 159 || new Location(location.getWorld(), i, j, k).getBlock().getType().getId() == 172 || new Location(location.getWorld(), i, j, k).getBlock().getType().getId() == 95 || new Location(location.getWorld(), i, j, k).getBlock().getType().getId() == 160)
					{
						new Location(location.getWorld(), i, j, k).getBlock().setData((byte) team.woolData);
					}
				}
			}
		}
	}
}
