package an0nym8us.positron.gamemode;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map.Entry;
import java.util.Random;
import java.util.Timer;
import java.util.UUID;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.block.Sign;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

import com.comphenix.packetwrapper.WrapperPlayServerSpawnEntityLiving;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketContainer;

import an0nym8us.positron.Main;
import an0nym8us.positron.WorldManager;
import an0nym8us.positron.gamemode.events.PhaseChangedEvent;
import an0nym8us.positron.listeners.BlitzXpListener;
import an0nym8us.positron.listeners.ChangeSpecialityMenuListener;
import an0nym8us.positron.listeners.ChatChannelListener;
import an0nym8us.positron.listeners.FriendlyFireLockListener;
import an0nym8us.positron.listeners.InfinityEnchListener;
import an0nym8us.positron.listeners.ManagementListener;
import an0nym8us.positron.listeners.NexusListener;
import an0nym8us.positron.listeners.NexusRegionDefListener;
import an0nym8us.positron.listeners.ResourceRespawnListener;
import an0nym8us.positron.menu.ChangeSpecialityMenu;
import an0nym8us.positron.menu.TeamJoinMenu;
import an0nym8us.positron.menu.shops.BrewingShop;
import an0nym8us.positron.menu.shops.WeaponsShop;
import an0nym8us.positron.modules.EnderFurnaceModule;
import an0nym8us.positron.scoreboard.StatisticsManager;
import an0nym8us.positron.speciality.SpecialityListener;
import an0nym8us.positron.timers.BossBarTimer;
import an0nym8us.positron.timers.CountdownTimer;
import an0nym8us.positron.timers.NexusTimer;
import an0nym8us.positron.timers.PhaseTimer;
import an0nym8us.utils.ConsoleColor;

public class Arena
{
	public enum Team
	{
		Null(-1, ChatColor.WHITE, Color.FUCHSIA, "Lobby", 0),
		Green(0, ChatColor.GREEN, Color.GREEN, "Green", 13),
		Red(1, ChatColor.RED, Color.RED, "Red", 14),
		Blue(2, ChatColor.BLUE, Color.BLUE, "Blue", 11),
		Yellow(3, ChatColor.YELLOW, Color.YELLOW, "Yellow", 4);
		
		public int teamID;
		public ChatColor chatColor;
		public Color color;
		public String name;
		public int woolData;
		
		Team(int teamID, ChatColor chatColor, Color color, String name, int woolData)
		{
			this.teamID = teamID;
			this.chatColor = chatColor;
			this.color = color;
			this.name = name;
			this.woolData = woolData;
		}
		
		public static Team GetByID(int id)
		{
			for(Team t : Team.values())
			{
				if(t.teamID == id)
				{
					return t;
				}
			}
			
			return null;
		}
	}
	
	public enum Phase
	{
		Null(-1, 2, "Voting"),
		Voting(0, 10, "Voting"),
		Phase1(1, 600, "Faza I"),
		Phase2(2, 600, "Faza II"),
		Phase3(3, 600, "Faza III"),
		Phase4(4, 600, "Faza IV"),
		Phase5(5, Integer.MAX_VALUE, "Faza V"),
		Finished(666, 120, "Koniec"),
		Closed(667, Integer.MAX_VALUE, "Server closed");
		
		public int ID;
		public int duration;
		public String name;
		
		Phase(int ID, int duration, String name)
		{
			this.ID = ID;
			this.duration = duration;
			this.name = name;
		}
		
		public static Phase GetByID(int id)
		{
			for(Phase p : Phase.values())
			{
				if(p.ID == id)
				{
					return p;
				}
			}
			
			return null;
		}
	}
	
	public final int MAX_NEXUS_HEALTH = 85;
	public final int MAX_PLAYERS = 120;
	
	public static StatisticsManager sm;
	
	public List<PPlayer> players;
	HashMap<Location, Team> spawns;
	public List<Nexus> nexuses;
	public HashMap<Team, List<Location>> enderFurnaces;
	
	String name;
	int arenaID;
	public World preWorld;
	public World arenaWorld;
	
	PhaseManager phaseManager;
	
	
	BossBarTimer bossBarTimer;
	
	public TeamJoinMenu tjMenu;
	public ChangeSpecialityMenu csMenu;
	
	public WeaponsShop weaponsShop;
	public BrewingShop brewingShop;
	
	// TODO: BUFF TIMERS
	
	public static FriendlyFireLockListener fflL;
	public static ResourceRespawnListener rrL;
	public static ManagementListener mL;
	public static InfinityEnchListener ieL;
	public static ChangeSpecialityMenuListener csmL;
	public static NexusListener nL;
	public static NexusRegionDefListener nrdL;
	public static ChatChannelListener ccL;
	public static BlitzXpListener bxL;
	public static List<SpecialityListener> sLs;
	
	public EnderFurnaceModule efM;
	
	// FLAGS
	
	public int minPlayerAmount = 99999;
	
	public Arena(int arenaID)
	{
		this(arenaID, Integer.toString(arenaID));
		
		fflL = new FriendlyFireLockListener(arenaID);
		rrL = new ResourceRespawnListener(arenaID);
		mL = new ManagementListener(arenaID);
		ieL = new InfinityEnchListener(arenaID);
		csmL = new ChangeSpecialityMenuListener(arenaID);
		nL = new NexusListener(arenaID);
		nrdL = new NexusRegionDefListener(arenaID);
		ccL = new ChatChannelListener(arenaID);
		bxL = new BlitzXpListener(arenaID);
		sLs = new ArrayList<SpecialityListener>();
		
		efM = new EnderFurnaceModule(arenaID);
		
		Bukkit.getServer().getPluginManager().registerEvents(fflL, Main.main);
		Bukkit.getServer().getPluginManager().registerEvents(rrL, Main.main);
		Bukkit.getServer().getPluginManager().registerEvents(mL, Main.main);
		Bukkit.getServer().getPluginManager().registerEvents(ieL, Main.main);
		Bukkit.getServer().getPluginManager().registerEvents(csmL, Main.main);
		Bukkit.getServer().getPluginManager().registerEvents(nL, Main.main);
		Bukkit.getServer().getPluginManager().registerEvents(ccL, Main.main);
		Bukkit.getServer().getPluginManager().registerEvents(nrdL, Main.main);
		Bukkit.getServer().getPluginManager().registerEvents(bxL, Main.main);
		RegisterSpecialityListeners();
		
		bossBarTimer = new BossBarTimer(arenaID, 1);
		bossBarTimer.Start();
	}
	
	Arena(int arenaID, String name)
	{
		this.arenaID = arenaID;
		this.name = name;
		
		try
		{
			tjMenu = new TeamJoinMenu();
			csMenu = new ChangeSpecialityMenu();
			
			weaponsShop = new WeaponsShop();
			brewingShop = new BrewingShop();
			
			Main.mm.AddMenu(tjMenu);
			Main.mm.AddMenu(csMenu);
			
			Main.mm.AddMenu(weaponsShop);
			Main.mm.AddMenu(brewingShop);
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
			Bukkit.getServer().getLogger().info(ConsoleColor.RED + "Positron GameMode executed exception at configuring menus. Plugin DISABLED!" + ConsoleColor.RESET);
			Bukkit.getServer().getPluginManager().disablePlugin(Main.main);
			
			return;
		}
		
		WorldManager.copyWorld(new File("plugins//Positron//worlds//PositronArena"), new File("world_positron_arena_" + arenaID));
		WorldManager.copyWorld(new File("plugins//Positron//worlds//PositronSpawn"), new File("world_positron_pre_" + arenaID));
		
		arenaWorld = Bukkit.createWorld(new WorldCreator("world_positron_arena_" + arenaID));
		preWorld = Bukkit.createWorld(new WorldCreator("world_positron_pre_" + arenaID));
		
		arenaWorld.setGameRuleValue("doMobSpawning", "false");
		preWorld.setGameRuleValue("doMobSpawning", "false");
		
		preWorld.setPVP(true);
		
		players = new ArrayList<PPlayer>();
		
		enderFurnaces = new HashMap<Team, List<Location>>();
		
		InitializeMapData();
		sm = new StatisticsManager(arenaID, this);
		
		phaseManager = new PhaseManager(arenaID);
		bossBarTimer = new BossBarTimer(arenaID, 1);
		
		bossBarTimer.Start();
		phaseManager.Start();
	}
	
	boolean RegisterSpecialityListeners()
	{
		try
		{
			for(Speciality s : Speciality.values())
			{
				SpecialityListener sl = s.listener.getDeclaredConstructor(int.class, int.class).newInstance(this.arenaID, s.id);
				Bukkit.getServer().getPluginManager().registerEvents(sl, Main.main);
				
				sLs.add(sl);
			}
		}
		catch(Exception ex)
		{
			return false;
		}
		
		return true;
	}
	
	public SpecialityListener GetSLById(int spID)
	{
		for(SpecialityListener sl : sLs)
		{
			if(sl.GetSPID() == spID)
			{
				return sl;
			}
		}
		
		return null;
	}
	
	public boolean CheckValidation(Location loc)
	{
		return loc.getWorld().equals(this.arenaWorld) || loc.getWorld().equals(this.preWorld);
	}
	
	public PhaseManager GetPM()
	{
		return phaseManager;
	}
	
	public Phase GetPhase()
	{
		return GetPM().phase;
	}
	
	public void Dispose()
	{
		phaseManager.phaseTimer.Abort();
		bossBarTimer.Abort();
		
		Bukkit.unloadWorld(arenaWorld, false);
		Bukkit.unloadWorld(preWorld, false);
		
		WorldManager.unloadWorld(arenaWorld);
		WorldManager.unloadWorld(preWorld);
		WorldManager.deleteWorld(arenaWorld.getWorldFolder());
		WorldManager.deleteWorld(preWorld.getWorldFolder());
	}
	
	public PPlayer GetPPlayer(UUID uuid)
	{
		for(PPlayer p : players)
		{
			if(p.uuid.equals(uuid))
			{
				return p;
			}
		}
			
		return null;
	}
	
	public boolean AddPlayer(UUID uuid)
	{
		if(!ContainsPlayer(uuid))
		{
			Main.ResetPlayerSettings(Bukkit.getPlayer(uuid));
			
			PPlayer p = new PPlayer(uuid, Team.Null, Speciality.Default, arenaID);
			players.add(p);
			
			return true;
		}
		
		return false;
	}
	
	public Nexus[] GetNexuses(Team team)
	{
		List<Nexus> list = new ArrayList<Nexus>();
		
		for(Nexus n : this.nexuses)
		{
			if(n.team.equals(team))
			{
				list.add(n);
			}
		}
		
		return list.toArray(new Nexus[list.size()]);
	}
	
	public boolean IsTeamDestroyed(Team team)
	{
		Nexus[] nexuses = GetNexuses(team);
		
		for(Nexus n : nexuses)
		{
			if(!n.IsDestroyed())
			{
				return false;
			}
		}
		
		return true;
	}
	
	public boolean PlayerJoinArena(UUID uuid)
	{
		try
		{
			if(!ContainsPlayer(uuid)) { AddPlayer(uuid); }
			TpPlayerToArena(uuid);
			
			return true;
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
			return false;
		}
	}
	
	boolean TeamContainsPlayer(UUID uuid, Team team)
	{
		for(PPlayer p : players)
		{
			if(p.Compare(uuid, team))
			{
				return true;
			}
		}
		
		return false;
	}
	
	public void TpPlayerToArena(UUID uuid)
	{
		PPlayer e = this.GetPPlayer(uuid);
		
		if(e.team.equals(Team.Null) || GetPhase().equals(Phase.Null) || GetPhase().equals(Phase.Voting))
		{
			Main.ResetPlayerSettings(Bukkit.getPlayer(uuid));
			
			Bukkit.getPlayer(uuid).teleport(preWorld.getSpawnLocation());					
			Bukkit.getPlayer(uuid).getInventory().addItem(Main.arena.tjMenu.openItem);
			Bukkit.getPlayer(uuid).getInventory().addItem(Main.arena.csMenu.openItem);
		}
		else if(GetNexuses(GetPPlayer(uuid).team)[0].IsDestroyed())
		{
			Bukkit.getPlayer(uuid).getInventory().clear();
			Bukkit.getPlayer(uuid).teleport(preWorld.getSpawnLocation());
		}
		else
		{
			Bukkit.getPlayer(uuid).teleport(GetRandomSpawnLoc(GetPPlayer(uuid).team));
		}
	}
	
	public boolean PlayerJoinTeam(UUID uuid, Team team)
	{
		PPlayer p = this.GetPPlayer(uuid);
		
		if(p.team.equals(Team.Null))
		{
			p.SetTeam(team);
			
			sm.AddPlayer(Bukkit.getPlayer(uuid), team);
			
			if(GetPhase() != Phase.Voting && GetPhase() != Phase.Null)
			{
				GetPPlayer(uuid).Refresh();
					
				Bukkit.getPlayer(uuid).teleport(GetRandomSpawnLoc(GetPPlayer(uuid).team));
			}
				
			return true;
		}
		
		return false;
	}
	
	public Nexus GetNearestNexus(Location loc)
	{
		double length = Double.MAX_VALUE;
		Nexus current = null;
		
		for(Nexus n : nexuses)
		{
			if(n.location.distance(loc) < length)
			{
				length = n.location.distance(loc);
				current = n;
			}
		}
		
		return current;
	}
	
	public Team GetNearestTeam(Location loc)
	{
		return GetNearestNexus(loc).team;
	}
	
	public boolean ContainsPlayer(UUID uuid)
	{
		for(PPlayer p : players)
		{
			if(p.uuid.equals(uuid))
			{
				return true;
			}
		}
		
		return false;
	}
	
	public Team GetPlayerTeam(UUID uuid)
	{
		for(PPlayer p : players)
		{
			if(p.uuid.equals(uuid))
			{
				return p.GetTeam();
			}
		}
		
		return null;
	}
	
	public Phase ChangePhase()
	{
		return ChangePhase(Phase.GetByID(GetPM().GetPhase().ID + 1));
	}
	
	public Phase ChangePhase(Phase phase)
	{
		GetPM().SetPhase(phase);
		
		return GetPM().GetPhase();
	}
	
	public void FinishGame()
	{
		GetPM().SetPhase(Phase.Finished);
	}
	
	public List<UUID> GetPlayers()
	{
		List<UUID> result = new ArrayList<UUID>();
		
		for(PPlayer p : players)
		{
			result.add(p.uuid);
		}
		
		return result;
	}
	
	public void CreateBossBarText(String text)
	{
		bossBarTimer = new BossBarTimer(arenaID, 1, text);		
		bossBarTimer.Start();
	}
	
	public Location GetRandomSpawnLoc(Team team)
	{
		List<Location> locs = GetTeamSpawnLoc(team);
		
		return locs.get(new Random().nextInt(locs.size()));
	}
	
	List<Location> GetTeamSpawnLoc(Team team)
	{
		List<Location> locs = new ArrayList<Location>();
		
		for(Entry<Location, Team> e : spawns.entrySet())
		{
			if(e.getValue().equals(team))
			{
				locs.add(e.getKey());
			}
		}
		return locs;
	}
	
	void InitializeMapData()
	{
		Bukkit.getServer().getLogger().info(ConsoleColor.RED + "INITIALIZING MAP DATA..." + ConsoleColor.RESET);
		
		spawns = new HashMap<Location, Team>();
		nexuses = new ArrayList<Nexus>();
		
		for(Team t : Team.values())
		{
			List<Location> list = new ArrayList<Location>();
			enderFurnaces.put(t, list);
		}
		
		for(Chunk c : arenaWorld.getLoadedChunks())
		{
			for(int i = 0; i < 16; i++)
			{
				Bukkit.getServer().broadcastMessage("Initializing map - " + Integer.toString(i * 100 / 16) + "%");
				
				for(int j = 0; j < 256; j++)
				{
					for(int k = 0; k < 16; k++)
					{
						if(c.getBlock(i, j, k).getType() == Material.SIGN_POST || c.getBlock(i, j, k).getType() == Material.WALL_SIGN)
						{
							Sign sign = (Sign)(c.getBlock(i, j, k).getState());
							
							if(sign.getLine(0).equals("TeamSpawn"))
							{
								for(Team team : Team.values())
								{
									if(sign.getLine(1).equals(team.name()))
									{
										spawns.put(c.getBlock(i, j, k).getLocation(), team);
										
										break;
									}
								}
								
								c.getBlock(i, j, k).setType(Material.AIR);
							}
							else if(sign.getLine(0).equals("Nexus"))
							{
								for(Team team : Team.values())
								{
									if(sign.getLine(1).equals(team.name()))
									{
										c.getBlock(i, j, k).setType(Material.ENDER_STONE);
										nexuses.add(new Nexus(arenaID, team, MAX_NEXUS_HEALTH, sign.getLocation()));
										
										break;
									}
								}
							}
							else if(sign.getLine(0).equals("EnderFurnace"))
							{
								for(Team team : Team.values())
								{
									if(sign.getLine(1).equals(team.name()))
									{
										enderFurnaces.get(team).add(sign.getLocation());
										sign.getLocation().getBlock().setType(Material.FURNACE);
									}
								}
							}
						}
					}
				}
			}
		}
	}
}
