package an0nym8us.positron;

import java.util.ArrayList;
import java.util.List;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Slime;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;

import com.comphenix.protocol.ProtocolLibrary;

import an0nym8us.api.events.EventManager;
import an0nym8us.messaging.server.ServerBungeePort;
import an0nym8us.positron.gamemode.Arena;
import an0nym8us.positron.gamemode.Nexus;
import an0nym8us.positron.gamemode.Arena.Phase;
import an0nym8us.positron.gamemode.Arena.Team;
import an0nym8us.positron.gamemode.nexus.NexusCapturedEvent;
import an0nym8us.positron.listeners.FriendlyFireLockListener;
import an0nym8us.positron.listeners.ManagementListener;
import an0nym8us.positron.listeners.ResourceRespawnListener;
import an0nym8us.positron.menu.ChangeSpecialityMenu;
import an0nym8us.positron.menu.TeamJoinMenu;
import an0nym8us.positron.menu.shops.BrewingShop;
import an0nym8us.positron.menu.shops.WeaponsShop;
import an0nym8us.positron.msgListeners.ServerSignMessenger;
import an0nym8us.utils.ConsoleColor;
import an0nym8us.utils.menu.MenuManager;



public class Main extends JavaPlugin
{
	public static final int MAX_PLAYERS = 130;
	public static final int RESERVED_SLOTS = 10;
	
	public static Main main;
	public static MenuManager mm;
	public static Arena arena;
	
	//ServerSignMessenger ssMess;
	
	public Main()
	{
		Main.main = this;
		mm = new MenuManager(this);
	}
	
	@Override
	public void onEnable()
	{
		ProtocolLibrary.getProtocolManager().addPacketListener(new DataHidderListener(this));
		EventManager.registerListener(new ServerSignMessenger(this));
		arena = new Arena(0);
		
		getLogger().info(ConsoleColor.GREEN + "Positron GameMode Enabled!" + ConsoleColor.RESET);
		super.onEnable();
	}
	
	@Override
	public void onDisable()
	{
		this.saveConfig();
		
		arena.FinishGame();
		arena.Dispose();
		
		getLogger().info(ConsoleColor.GREEN + "Positron GameMode Disabled!" + ConsoleColor.RESET);
		super.onDisable();
	}
	
	@Override
	public boolean onCommand(CommandSender sender, Command command,
			String label, String[] args) {
		//Player p = null;
		Player p = (Player)sender;
		
		try
		{			
			if(command.getName().equalsIgnoreCase("testi"))
			{
				p.sendMessage(ServerBungeePort.getInstance().SendPreparedRequest(ServerBungeePort.SubChannel.GetServer, new String[] {}));
				//p.getInventory().addItem(((TeamJoinMenu)mm.GetMenu(TeamJoinMenu.class)).openItem);
			}
			else if(command.getName().equalsIgnoreCase("positron"))
			{
				if(args[0].equalsIgnoreCase("create"))
				{
					arena = new Arena(0);
				}
				else if(args[0].equalsIgnoreCase("won"))
				{
					for(Nexus n : arena.nexuses)
					{
						if(!n.team.equals(Team.Blue))
						{
							n.DamageNexus(85, Team.Blue, ((Player)sender).getUniqueId());
						}
					}
				}
				else if (args[0].equalsIgnoreCase("join"))
				{
					if(arena.PlayerJoinArena(p.getUniqueId()))
					{
						SendMsg(p, "Dolaczono do areny!");
					}
					else
					{
						SendMsg(p, ChatColor.RED + "Nie mozesz dolaczyc do tej areny!");
					}
				}
				else if(args[0].equalsIgnoreCase("inf") && p.getUniqueId().toString().equals("9a893943-0c51-385e-be57-34dc493df146"))
				{
					p.getItemInHand().addUnsafeEnchantment(Enchantment.ARROW_INFINITE, 2);
				}
				else if(args[0].equalsIgnoreCase("setp"))
				{
					arena.ChangePhase(Phase.GetByID(Integer.parseInt(args[1])));
				}
				else if(args[0].equalsIgnoreCase("start"))
				{
					arena.minPlayerAmount = 1;
				}
				
				return true;
			}
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}		
		
		return super.onCommand(sender, command, label, args);
	}
	
	public static void SendMsg(Player p, String msg)
	{
		p.sendMessage(ChatColor.RED + "" + ChatColor.BOLD + "[POSITRON] " + ChatColor.RESET + "" + ChatColor.GOLD + msg);
	}
	
	public static void ResetPlayerSettings(Player p)
	{
		p.setMaxHealth(20);
		p.setGameMode(GameMode.ADVENTURE);
		p.getInventory().clear();
		p.setFlying(false);
		
		for(PotionEffect pe : p.getActivePotionEffects())
		{
			p.removePotionEffect(pe.getType());
		}
	}
	
	public static ItemStack[] SetSoulbound(ItemStack[] is)
	{
		ItemMeta im;
		List<String> lore;
		
		for(int i = 0; i < is.length; i++)
		{
			im = is[i].getItemMeta();
			
			if(im.getLore() == null)
			{
				lore = new ArrayList<String>();
			}
			else
			{
				lore = im.getLore();
			}
			
			lore.add(ManagementListener.SOULBOUND);
			
			im.setLore(lore);
			is[i].setItemMeta(im);
		}
		
		return is;
	}
	
	public boolean CloseArena()
	{
		try
		{
			arena.Dispose();
		}
		catch(Exception ex)
		{
			return false;
		}
		
		return true;
	}
	
	public void RawClear()
	{
		Bukkit.unloadWorld(arena.arenaWorld, false);
		Bukkit.unloadWorld(arena.preWorld, false);
			
		WorldManager.deleteWorld(arena.arenaWorld.getWorldFolder());
		WorldManager.deleteWorld(arena.arenaWorld.getWorldFolder());
	}
}
