package an0nym8us.positron;

import java.util.List;

import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

import com.comphenix.packetwrapper.WrapperPlayServerSetSlot;
import com.comphenix.protocol.Packets;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;

public class DataHidderListener extends PacketAdapter
{
	public DataHidderListener(Plugin plugin) {
		super(PacketAdapter.params(plugin, Packets.Server.SET_SLOT).clientSide().serverSide());
	}

	@Override
	public void onPacketSending(PacketEvent event)
	{
			WrapperPlayServerSetSlot wp = new WrapperPlayServerSetSlot(event.getPacket());
			
			ItemStack is = wp.getSlotData();
			
			if(is == null || is.getItemMeta() == null || !is.getItemMeta().hasLore()) { return; }
			
			ItemMeta im = is.getItemMeta();
			
			List<String> lore = im.getLore();
			
			for(int i = 0; i < lore.size(); i++)
			{
				if(lore.get(i).startsWith("+"))
				{
					lore.remove(i);
					i--;
				}
			}
			
			im.setLore(lore);
			is.setItemMeta(im);
			wp.setSlotData(is);
			event.setPacket(wp.getHandle());
	}
}
