package an0nym8us.warmonger.functions;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;

import an0nym8us.warmonger.ISettable;
import an0nym8us.warmonger.Unit;
import an0nym8us.warmonger.Variable;
import an0nym8us.warmonger.Warmonger;

public class SetFunction<T, U extends Unit & ISettable<T>> extends Function<T>
{
	U rootValue;
	Variable<T> parameter;
	
	public SetFunction(U rootValue, Variable<T> parameter)
	{
		this.rootValue = rootValue;
		this.parameter = parameter;
	}
	
	public long GetCurrentSerializationVersion()
	{
		return 0L;
	}
	
	public void readUnit(long serializationVersion, DataInput input) throws IOException
	{
		rootValue = (U) Warmonger.Read(input);
		parameter = (Variable<T>) Warmonger.Read(input);
	}
	
	public void writeUnit(long serializationVersion, DataOutput output) throws IOException
	{
		Warmonger.Write(rootValue, output);
		Warmonger.Write(parameter, output);
	}

	@Override
	public Variable<T> Execute(Map<String, Object> params)
	{
		rootValue.SetValue(params, parameter.GetValue(params));
		
		if(rootValue instanceof Variable)
		{
			return (Variable<T>) rootValue;
		}
		
		return null;
	}
}
