package an0nym8us.warmonger.functions;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;

import an0nym8us.warmonger.ISettable;
import an0nym8us.warmonger.Variable;
import an0nym8us.warmonger.Warmonger;

public class RemoveElementFunction<T, U extends Variable<T[]> & ISettable<T[]>> extends Function<T[]>
{
	U array;
	Variable<T>[] parameters;
	int[] parameterIndexes;

	public RemoveElementFunction(U array, Variable<T>... parameters)
	{
		this(array, parameters, null);
	}

	public RemoveElementFunction(U array, int... parameterIndexes)
	{
		this(array, null, parameterIndexes);
	}

	public RemoveElementFunction(U array, Variable<T>[] parameters, int[] parameterIndexes)
	{
		this.array = array;
		this.parameters = parameters;
		this.parameterIndexes = parameterIndexes;
	}
	
	public long GetCurrentSerializationVersion()
	{
		return 0L;
	}
	
	public void readUnit(long serializationVersion, DataInput input) throws IOException
	{
		array = (U) Warmonger.Read(input);
		
		parameters = new Variable[input.readInt()];
		
		for(int i = 0; i < parameters.length; i++)
		{
			parameters[i] = (Variable<T>) Warmonger.Read(input);
		}
		
		parameterIndexes = new int[input.readInt()];
		
		for(int i = 0; i < parameterIndexes.length; i++)
		{
			parameterIndexes[i] = input.readInt();
		}
	}
	
	public void writeUnit(long serializationVersion, DataOutput output) throws IOException
	{
		Warmonger.Write(array, output);
		
		output.writeInt(parameters.length);
		
		for(int i = 0; i < parameters.length; i++)
		{
			Warmonger.Write(parameters[i], output);
		}
		
		output.writeInt(parameterIndexes.length);
		
		for(int i = 0; i < parameterIndexes.length; i++)
		{
			output.writeInt(parameterIndexes[i]);
		}
	}

	@Override
	public Variable<T[]> Execute(Map<String, Object> params)
	{
		T[] array = this.array.GetValue(params);
		T[] newArray = (T[]) new Object[array.length];

		int gap = 0;

		outerloop: for (int i = 0; i < array.length; i++)
		{
			for (Variable<T> iValue : parameters)
			{
				if (iValue.DoesMatch(params, array[i]))
				{
					gap++;

					continue outerloop;
				}
			}

			newArray[i - gap] = array[i];
		}

		T[] res = (T[]) new Object[newArray.length - gap];

		for (int i = 0; i < res.length; i++)
		{
			res[i] = newArray[i];
		}

		this.array.SetValue(params, res);
		
		return this.array;
	}

}
