package an0nym8us.warmonger.functions;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;

import an0nym8us.warmonger.ISettable;
import an0nym8us.warmonger.Variable;
import an0nym8us.warmonger.Warmonger;

public class MathFunction<T extends Variable<? extends Number> & ISettable<? extends Number>> extends Function<Number>
{
	public static enum MathActionType
	{
		Add(0),
		Subtract(1),
		Multiply(2),
		Divide(3),
		Increment(4),
		Decrement(5);
		
		int id;
		
		MathActionType(int id)
		{
			this.id = id;
		}
		
		public int GetID()
		{
			return id;
		}
		
		public static MathActionType GetType(int id)
		{
			for(MathActionType mat : MathActionType.values())
			{
				if(mat.id == id)
				{
					return mat;
				}
			}
			
			return null;
		}
	}
	
	MathActionType mathActionType;
	T rootValue;
	Variable<Number>[] parameters;
	
	@SafeVarargs
	public MathFunction(T rootValue, MathActionType mathActionType, Variable<Number>... parameters)
	{
		this.rootValue = rootValue;
		this.mathActionType = mathActionType;
		this.parameters = parameters;
	}
	
	public long GetCurrentSerializationVersion()
	{
		return 0L;
	}
	
	public void readUnit(long serializationVersion, DataInput input) throws IOException
	{
		mathActionType = MathActionType.GetType(input.readInt());
		
		rootValue = (T) Warmonger.Read(input);
		
		parameters = new Variable[input.readInt()];
		
		for(int i = 0; i < parameters.length; i++)
		{
			parameters[i] = (Variable<Number>) Warmonger.Read(input);
		}
	}
	
	public void writeUnit(long serializationVersion, DataOutput output) throws IOException
	{
		output.writeInt(mathActionType.GetID());
		
		Warmonger.Write(rootValue, output);
		
		output.writeInt(parameters.length);
		
		for(int i = 0; i < parameters.length; i++)
		{
			Warmonger.Write(parameters[i], output);
		}
	}

	@Override
	public Variable<Number> Execute(Map<String, Object> params)
	{
		Double d = rootValue.GetValue(params).doubleValue();

		switch(mathActionType)
		{
			case Add:
				for (Variable<Number> iV : parameters)
				{
					d += ((Number) iV.GetValue(params)).doubleValue();
				}
				break;
			case Subtract:
				for (Variable<Number> iV : parameters)
				{
					d -= ((Number) iV.GetValue(params)).doubleValue();
				}
				break;
			case Multiply:
				for (Variable<Number> iV : parameters)
				{
					d *= ((Number) iV.GetValue(params)).doubleValue();
				}
				break;
			case Divide:
				for (Variable<Number> iV : parameters)
				{
					d /= ((Number) iV.GetValue(params)).doubleValue();
				}
				break;
			case Increment:
				d += 1;
				break;
			case Decrement:
				d -= 1;
				break;
		}

		((ISettable<Number>)rootValue).SetValue(params, d); // If doesn't work, then try ISettable without generic type.
		
		return (Variable<Number>) rootValue;
	}
}
