package an0nym8us.warmonger.functions;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;

import an0nym8us.warmonger.Constant;
import an0nym8us.warmonger.Variable;
import an0nym8us.warmonger.Warmonger;

public class LoopFunction extends IfFunction<Boolean>
{
	Function<?>[] functions;

	public LoopFunction(Variable<Boolean> condition, Function<?>... actions)
	{
		super(condition);
		
		this.functions = actions;
	}

	public long GetCurrentSerializationVersion()
	{
		return 0L;
	}

	public void readUnit(long serializationVersion, DataInput input) throws IOException
	{
		functions = new Function<?>[input.readInt()];

		for (int i = 0; i < functions.length; i++)
		{
			functions[i] = (Function<?>) Warmonger.Read(input);
		}
	}

	public void writeUnit(long serializationVersion, DataOutput output) throws IOException
	{
		output.writeInt(functions.length);
		
		for (int i = 0; i < functions.length; i++)
		{
			Warmonger.Write(functions[i], output);
		}
	}

	@Override
	public Variable<Boolean> PostExecute(Map<String, Object> params)
	{
		while (condition.GetValue(params))
		{
			for (Function<?> function : functions)
			{
				function.Execute(params);
			}
		}

		return new Constant<Boolean>(true);
	}
}
