package an0nym8us.warmonger.functions;

import java.util.Map;

import an0nym8us.warmonger.Variable;

public abstract class IfFunction<T> extends Function<T>
{
	Variable<Boolean> condition;
	
	public IfFunction(Variable<Boolean> condition)
	{
		this.condition = condition;
	}
	
	@Override
	public Variable<T> Execute(Map<String, Object> params)
	{	
		if(condition.GetValue(params))
		{
			return PostExecute(params);
		}
		
		return null;
	}
	
	public abstract Variable<T> PostExecute(Map<String, Object> params);
}
