package an0nym8us.warmonger.functions;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;

import an0nym8us.warmonger.Constant;
import an0nym8us.warmonger.Variable;
import an0nym8us.warmonger.Warmonger;

public class GetElementFunction<T> extends Function<T>
{
	Variable<T[]> array;
	Variable<Number> index;
	
	public GetElementFunction(Variable<T[]> array, Variable<Number> index)
	{
		this.array = array;
		this.index = index;
	}
	
	@Override
	public long GetCurrentSerializationVersion()
	{
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public void writeUnit(long serializationVersion, DataOutput output) throws IOException
	{
		Warmonger.Write(array, output);
		Warmonger.Write(index, output);
	}

	@Override
	public void readUnit(long serializationVersion, DataInput input) throws IOException
	{
		array = (Variable<T[]>) Warmonger.Read(input);
		index = (Variable<Number>) Warmonger.Read(input);
	}

	@Override
	public Variable<T> Execute(Map<String, Object> params)
	{
		return new Constant<T>(array.GetValue(params)[index.GetValue(params).intValue()]);
	}
}
