package an0nym8us.warmonger.functions;

import java.util.Map;

import an0nym8us.warmonger.Variable;

public abstract class Function<T> implements Variable<T>
{
	public T GetValue(final Map<String, Object> params)
	{
		return Execute(params).GetValue(params);
	}

	public boolean DoesMatch(final Map<String, Object> params, T value)
	{
		return GetValue(params).equals(value);
	}

	public abstract Variable<T> Execute(Map<String, Object> params);
}
