package an0nym8us.warmonger.functions;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;

import an0nym8us.warmonger.IDeleteable;
import an0nym8us.warmonger.Variable;
import an0nym8us.warmonger.Warmonger;

public class DeleteFunction<T, V extends Variable<T> & IDeleteable<T>> extends Function<T>
{
	V affectedValue;
	
	public DeleteFunction(V affectedValue)
	{
		this.affectedValue = affectedValue;
	}
	
	@Override
	public V Execute(Map<String, Object> params)
	{
		affectedValue.DeleteValue(params);
		
		return affectedValue;
	}

	@Override
	public long GetCurrentSerializationVersion()
	{
		return 0;
	}

	@Override
	public void writeUnit(long serializationVersion, DataOutput output) throws IOException
	{
		Warmonger.Write(affectedValue, output);
		
	}

	@Override
	public void readUnit(long serializationVersion, DataInput input) throws IOException
	{
		affectedValue = (V) Warmonger.Read(input);
	}
}
