package an0nym8us.warmonger.functions;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;

import an0nym8us.warmonger.Constant;
import an0nym8us.warmonger.Variable;
import an0nym8us.warmonger.Warmonger;

public class ComparisionFunction<T> extends Function<Boolean>
{
	Variable<T> value0;
	Variable<T> value1;
	
	public ComparisionFunction(Variable<T> value0, Variable<T> value1)
	{
		this.value0 = value0;
		this.value1 = value1;
	}
	
	public long GetCurrentSerializationVersion()
	{
		return 0L;
	}
	
	public void readUnit(long serializationVersion, DataInput input) throws IOException
	{
		value0 = (Variable<T>) Warmonger.Read(input);
		value1 = (Variable<T>) Warmonger.Read(input);
	}
	
	public void writeUnit(long serializationVersion, DataOutput output) throws IOException
	{
		Warmonger.Write(value0, output);
		Warmonger.Write(value1, output);
	}

	@Override
	public Variable<Boolean> Execute(Map<String, Object> params)
	{
		return new Constant<Boolean>(value0.DoesMatch(params, value1));
	}
}