package an0nym8us.warmonger.functions;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;

import an0nym8us.warmonger.Constant;
import an0nym8us.warmonger.Variable;
import an0nym8us.warmonger.Warmonger;

public class CompareElementFunction<T> extends Function<Boolean>
{
	Variable<T[]> array;
	Variable<Number> index;
	
	Variable<T> value1;
	
	public CompareElementFunction(Variable<T[]> array, Variable<Number> index, Variable<T> value1)
	{
		this.array = array;
		this.index = index;
		this.value1 = value1;
	}
	
	@Override
	public long GetCurrentSerializationVersion()
	{
		return 0;
	}

	@Override
	public void writeUnit(long serializationVersion, DataOutput output) throws IOException
	{
		Warmonger.Write(array, output);
		Warmonger.Write(index, output);
		
		Warmonger.Write(value1, output);
	}

	@Override
	public void readUnit(long serializationVersion, DataInput input) throws IOException
	{
		array = (Variable) Warmonger.Read(input);
		index = (Variable<Number>) Warmonger.Read(input);
		
		value1 = (Variable<T>) Warmonger.Read(input);
	}

	@Override
	public Variable<Boolean> Execute(Map<String, Object> params)
	{
		return new Constant<Boolean>(value1.DoesMatch(params, array.GetValue(params)[index.GetValue(params).intValue()]));
	}
}
