package an0nym8us.warmonger.functions;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;

import an0nym8us.warmonger.ISettable;
import an0nym8us.warmonger.Variable;
import an0nym8us.warmonger.Warmonger;

public class AddElementFunction<T, U extends Variable<T[]> & ISettable<T[]>> extends Function<T[]>
{
	U array;
	Variable<T> parameter;
	
	public AddElementFunction(U array, Variable<T> parameter)
	{		
		this.array = array;
		this.parameter = parameter;
	}
	
	public long GetCurrentSerializationVersion()
	{
		return 0L;
	}
	
	public void readUnit(long serializationVersion, DataInput input) throws IOException
	{
		parameter = (Variable<T>) Warmonger.Read(input);
	}
	
	public void writeUnit(long serializationVersion, DataOutput output) throws IOException
	{
		Warmonger.Write(parameter, output);
	}

	@Override
	public Variable<T[]> Execute(Map<String, Object> params)
	{
		T[] array = this.array.GetValue(params);
		T[] newArray = (T[])new Object[array.length + 1];
		
		for(int i = 0; i < array.length; i++)
		{
			newArray[i] = array[i];
		}
		
		newArray[array.length] = parameter.GetValue(params);
		
		((ISettable<T[]>)this.array).SetValue(params, array);
		
		return null;
	}

}
