package an0nym8us.warmonger;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.UUID;

import org.bukkit.Bukkit;
import org.bukkit.World;

import an0nym8us.bukkit.magicCrafting.NMSProvider;

public class WorldVariable<T> implements Variable<T>, ISettable<T>
{
	public static final String WORLD_CODE = "world";

	protected static Class<?> _nbtTagCompound;
	protected static Class<?> _craftWorld;
	protected static Class<?> _world;
	protected static Class<?> _worldData;

	protected static Method _cW_getHandle;
	protected static Method _w_getWorldData;
	protected static Constructor<?> _wD_constructor;
	protected static Method _wD_writeNBT;

	static
	{
		try
		{
			_nbtTagCompound = NMSProvider
					.GetClass("net.minecraft.server." + NMSProvider.GetNMSVersion() + ".NBTTagCompound");
			_craftWorld = NMSProvider.GetClass("org.bukkit.craftbukkit." + NMSProvider.GetNMSVersion() + ".CraftWorld");
			_world = NMSProvider.GetClass("net.minecraft.server." + NMSProvider.GetNMSVersion() + ".World");
			_worldData = NMSProvider.GetClass("net.minecraft.server." + NMSProvider.GetNMSVersion() + ".WorldData");

			_cW_getHandle = NMSProvider.GetMethod(_craftWorld, "getHandle");
			_w_getWorldData = NMSProvider.GetMethod(_world, "getWorldData");
			_wD_constructor = _worldData.getConstructor(_nbtTagCompound);
			_wD_writeNBT = NMSProvider.GetMethod(_worldData, "a", _nbtTagCompound);
		}
		catch (ClassNotFoundException | NoSuchMethodException | SecurityException e)
		{
			e.printStackTrace();
		}
	}

	Variable<UUID> worldUUID;
	Variable<NBTAbstractValue<T>> nbtValue;

	public WorldVariable(Variable<UUID> worldUUID, NBTAbstractValue<T> nbtValue)
	{
		this.worldUUID = worldUUID;
		this.nbtValue = new Constant<NBTAbstractValue<T>>(nbtValue);
	}
	
	public long GetCurrentSerializationVersion()
	{
		return 0L;
	}
	
	public void readUnit(long serializationVersion, DataInput input) throws IOException
	{
		worldUUID = (Variable<UUID>) Warmonger.Read(input);
		
		nbtValue = (Variable<NBTAbstractValue<T>>) Warmonger.Read(input);
	}
	
	public void writeUnit(long serializationVersion, DataOutput output) throws IOException
	{
		Warmonger.Write(worldUUID, output);
		
		Warmonger.Write(nbtValue, output);
	}

	@Override
	public boolean SetValue(Map<String, Object> params, T value)
	{
		try
		{
			Object nmsWorld = _cW_getHandle.invoke(params.get(WORLD_CODE));
			Object nativeWorldData = _w_getWorldData.invoke(nmsWorld);

			Object nbtTagCompound = _wD_writeNBT.invoke(nativeWorldData, (Object) null);

			if (!nbtValue.GetValue(params).SetValue(nbtTagCompound, value)) { return false; }

			Object improvedWorldData = _wD_constructor.newInstance(nbtTagCompound);
			
			for(Field field : _worldData.getDeclaredFields())
			{
				field.setAccessible(true);
				
				if(field.get(improvedWorldData) != null)
				{
					try
					{
					field.set(nativeWorldData, field.get(improvedWorldData));
					}
					catch(Exception ex) { }
				}
			}
			
			Field field = _world.getDeclaredField("worldData");
			field.set(nmsWorld, nativeWorldData);
			
			return true;
		}
		catch (IllegalAccessException | SecurityException ex)
		{
			ex.printStackTrace();
		}
		catch (InstantiationException | IllegalArgumentException | InvocationTargetException ex)
		{

		}
		catch (NoSuchFieldException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return false;
	}

	@Override
	public T GetValue(Map<String, Object> params)
	{
		try
		{
			Object nmsWorld = GetNMSWorld(params);

			Object worldData = _w_getWorldData.invoke(nmsWorld);

			Object nbtTagCompound = _wD_writeNBT.invoke(worldData, (Object) null);

			return nbtValue.GetValue(params).GetValue(nbtTagCompound);
		}
		catch (IllegalAccessException | SecurityException ex)
		{
			ex.printStackTrace();
		}
		catch (IllegalArgumentException | InvocationTargetException ex)
		{

		}

		return null;
	}

	protected Object GetWorldNBT(World world)
	{
		try
		{
			Object nmsWorld = _cW_getHandle.invoke(world);

			return _w_getWorldData.invoke(nmsWorld);
		}
		catch (IllegalAccessException | SecurityException ex)
		{
			ex.printStackTrace();
		}
		catch (IllegalArgumentException | InvocationTargetException ex)
		{

		}

		return null;
	}
	
	protected World GetWorld(Map<String, Object> params)
	{
		return Bukkit.getWorld(worldUUID.GetValue(params));
	}
	
	protected Object GetNMSWorld(Map<String, Object> params)
	{
		try
		{
			return _cW_getHandle.invoke(GetWorld(params));
		}
		catch (InvocationTargetException | IllegalAccessException e)
		{
			e.printStackTrace();
		}
		catch (IllegalArgumentException e)
		{
			
		}
		
		return null;
	}

	@Override
	public boolean DoesMatch(Map<String, Object> params, T value)
	{
		return GetValue(params).equals(value);
	}
}
