package an0nym8us.warmonger;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

public class Warmonger
{
	private static final Map<String, Class<? extends Unit>> types = new HashMap<String, Class<? extends Unit>>();

	static
	{

	}

	public static boolean RegisterType(String ID, Class<? extends Unit> clazz)
	{
		if (!types.containsKey(ID))
		{
			types.put(ID, clazz);

			return true;
		}

		return false;
	}

	public static String GetID(Class<? extends Unit> clazz)
	{
		for (Entry<String, Class<? extends Unit>> entry : types.entrySet())
		{
			if (entry.getValue() == clazz) { return entry.getKey(); }
		}

		return null;
	}

	public static Class<? extends Unit> GetClass(String ID)
	{
		return types.get(ID);
	}
	
	public static final void WriteSignature(Class<? extends Unit> clazz, long serializationVersion, DataOutput output) throws IOException
	{
		output.writeUTF(Warmonger.GetID(clazz));
		output.writeLong(serializationVersion);
	}
	
	private static final void Write(Unit unit, Class<?> clazz, DataOutput output) throws IOException
	{
		long serializationVersion = ((Unit)clazz.cast(unit)).GetCurrentSerializationVersion();
		WriteSignature((Class<? extends Unit>)clazz, serializationVersion, output);
		
		if(Unit.class.isAssignableFrom(clazz))
		{
			Write(unit, clazz.getSuperclass(), output);
		}
		
		try
		{
			Method method = clazz.getDeclaredMethod("writeUnit", Long.class, DataOutput.class);
			method.setAccessible(true);
			
			method.invoke(unit, serializationVersion, output);
		}
		catch (NoSuchMethodException | SecurityException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e)
		{
			e.printStackTrace();
		}
	}
	
	public static final void Write(Unit unit, DataOutput output) throws IOException
	{
		output.writeLong(0L);
		
		Write(unit, unit.getClass(), output);
	}
	
	private static final Unit Read(DataInput input, Unit unit) throws IOException
	{
		String id = input.readUTF();
		long serVer = input.readLong();
		
		Class<? extends Unit> clazz = Warmonger.GetClass(id);
		
		if(Unit.class.isAssignableFrom(clazz))
		{
			unit = Read(input, unit);
		}
		
		try
		{
			Method method = clazz.getDeclaredMethod("readUnit", Long.class, DataInput.class);
			method.setAccessible(true);
			
			method.invoke(unit, serVer, input);
		}
		catch (NoSuchMethodException | SecurityException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e)
		{
			e.printStackTrace();
		}

		return null;
	}
	
	public static final Unit Read(DataInput input) throws IOException
	{
		Long warmongerID = input.readLong();
		
		String id = input.readUTF();
		long serVer = input.readLong();
		
		Class<? extends Unit> clazz = Warmonger.GetClass(id);
		
		try
		{
			Unit unit = clazz.newInstance();
			
			unit = Read(input, unit);
			
			unit.readUnit(serVer, input);

			return unit;
		}
		catch (InstantiationException | IllegalAccessException e)
		{
			e.printStackTrace();
		}

		return null;
	}
}
