package an0nym8us.warmonger;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;

public class UUIDVariable implements Variable<UUID>
{
	Variable<Long> mostBits;
	Variable<Long> leastBits;
	
	public UUIDVariable(UUID uuid)
	{
		this(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
	}
	
	public UUIDVariable(Long mostBits, Long leastBits)
	{
		this.mostBits = new Constant<Long>(mostBits);
		this.leastBits = new Constant<Long>(leastBits);
	}
	
	public long GetCurrentSerializationVersion()
	{
		return 0L;
	}
	
	public void readUnit(long serializationVersion, DataInput input) throws IOException
	{
		mostBits = (Variable<Long>) Warmonger.Read(input);
		leastBits = (Variable<Long>) Warmonger.Read(input);
	}
	
	public void writeUnit(long serializationVersion, DataOutput output) throws IOException
	{
		Warmonger.Write(mostBits, output);
		Warmonger.Write(leastBits, output);
	}
	
	@Override
	public UUID GetValue(Map<String, Object> params)
	{
		return new UUID(mostBits.GetValue(params), leastBits.GetValue(params));
	}

	@Override
	public boolean DoesMatch(Map<String, Object> params, UUID value)
	{
		return value.getMostSignificantBits() == mostBits.GetValue(params) && value.getLeastSignificantBits() == leastBits.GetValue(params);
	}

}
