package an0nym8us.warmonger;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;

import an0nym8us.warmonger.functions.AbortFunction;
import an0nym8us.warmonger.functions.Function;

public class Program extends Function<Integer>
{
	public static final int SUCCESS_CODE = 0;
	public static final int GENERAL_FAILURE_CODE = -1;
	
	Function<?>[] functions;

	public Program(Function<?>... functions)
	{
		this.functions = functions;
	}

	private void readObject(ObjectInputStream input) throws IOException
	{
		functions = new Function<?>[input.readInt()];

		for (int i = 0; i < functions.length; i++)
		{
			functions[i] = (Function<?>) Warmonger.Read(input);
		}
	}

	private void writeObject(ObjectOutputStream output) throws IOException
	{
		output.writeInt(functions.length);

		for (int i = 0; i < functions.length; i++)
		{
			Warmonger.Write(functions[i], output);
		}
	}

	public Map<String, Object> PrepareParams()
	{
		Map<String, Object> res = new HashMap<String, Object>();

		PrepareParams(res);

		return res;
	}

	public void PrepareParams(Map<String, Object> params)
	{

	}

	public Variable<Integer> Execute(Map<String, Object> params)
	{
		for (Function<?> function : functions)
		{
			if (IsAborted(params)) { return new Constant<Integer>(-1); }

			function.Execute(params);
		}

		return new Constant<Integer>(0);
	}

	protected boolean IsAborted(Map<String, Object> params)
	{
		return params.containsKey(AbortFunction.ABORT_CODE) && (boolean) params.get(AbortFunction.ABORT_CODE);
	}

	@Override
	public long GetCurrentSerializationVersion()
	{
		return 0;
	}
	
	public void writeUnit(long serializationVersion, DataOutput output) throws IOException
	{
		output.writeInt(functions.length);
		
		for(Function<?> function : functions)
		{
			Warmonger.Write(function, output);
		}
	}
	
	public void readUnit(long serializationVersion, DataInput input) throws IOException
	{
		functions = new Function[input.readInt()];
		
		for(int i = 0; i < functions.length; i++)
		{
			functions[i] = (Function<?>) Warmonger.Read(input);
		}
	}
}
