package an0nym8us.warmonger;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;

public class Pointer<T> implements Variable<T>, ISettable<T>, IDeleteable<T>
{
	Variable<? extends Unit> var;
	
	public Pointer(String path)
	{
		var = new LocalVariable<Variable<T>>(path);
	}
	
	public Pointer(Variable<Unit> var)
	{
		this.var = var;
	}
	
	@Override
	public long GetCurrentSerializationVersion()
	{
		return 0;
	}

	@Override
	public void writeUnit(long serializationVersion, DataOutput output) throws IOException
	{
		Warmonger.Write(var, output);
	}

	@Override
	public void readUnit(long serializationVersion, DataInput input) throws IOException
	{
		var = (Variable<? extends Unit>) Warmonger.Read(input);
	}

	@Override
	public T GetValue(Map<String, Object> params)
	{
		return ((Variable<T>)var.GetValue(params)).GetValue(params);
	}

	@Override
	public boolean DoesMatch(Map<String, Object> params, T value)
	{
		return ((Variable<T>)var.GetValue(params)).DoesMatch(params, value);
	}

	@Override
	public boolean DeleteValue(Map<String, Object> params)
	{
		return ((IDeleteable<T>)var.GetValue(params)).DeleteValue(params);
	}

	@Override
	public boolean SetValue(Map<String, Object> params, T value)
	{
		return ((ISettable<T>)var.GetValue(params)).SetValue(params, value);
	}

}
