package an0nym8us.warmonger;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.UUID;

import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

import an0nym8us.bukkit.magicCrafting.NMSProvider;

public class PlayerValue<T> implements Variable<T>, ISettable<T>
{
	public static final String PLAYER_CODE = "player";

	protected static Class<?> _nbtTagCompound;
	protected static Class<?> _craftPlayer;
	protected static Class<?> _entityPlayer;

	protected static Method _cP_getHandle;
	protected static Method _eP_readNBT;
	protected static Method _eP_writeNBT;

	static
	{
		try
		{
			_nbtTagCompound = NMSProvider
					.GetClass("net.minecraft.server." + NMSProvider.GetNMSVersion() + ".NBTTagCompound");
			_craftPlayer = NMSProvider.GetClass("org.bukkit.craftbukkit." + NMSProvider.GetNMSVersion() + ".CraftPlayer");
			_entityPlayer = NMSProvider
					.GetClass("net.minecraft.server." + NMSProvider.GetNMSVersion() + ".EntityPlayer");

			_cP_getHandle = NMSProvider.GetMethod(_craftPlayer, "getHandle");
			_eP_readNBT = NMSProvider.GetMethod(_entityPlayer, "a", _nbtTagCompound);
			_eP_writeNBT = NMSProvider.GetMethod(_entityPlayer, "b", _nbtTagCompound);
		}
		catch (ClassNotFoundException | NoSuchMethodException | SecurityException e)
		{
			e.printStackTrace();
		}
	}

	Variable<UUID> playerUUID;
	
	Variable<NBTAbstractValue<T>> nbtValue;

	public PlayerValue(Variable<UUID> playerUUID, NBTAbstractValue<T> nbtValue)
	{
		this.playerUUID = playerUUID;
		this.nbtValue = new Constant<NBTAbstractValue<T>>(nbtValue);
	}
	
	public long GetCurrentSerializationVersion()
	{
		return 0L;
	}
	
	public void readUnit(long serializationVersion, DataInput input) throws IOException
	{
		playerUUID = (Variable<UUID>) Warmonger.Read(input);
		
		nbtValue = (Variable<NBTAbstractValue<T>>) Warmonger.Read(input);
	}
	
	public void writeUnit(long serializationVersion, DataOutput output) throws IOException
	{
		Warmonger.Write(playerUUID, output);
		
		Warmonger.Write(nbtValue, output);
	}

	@Override
	public boolean SetValue(Map<String, Object> params, T value)
	{
		try
		{
			Object entityPlayer = GetEntityPlayer(params);
			
			Object nbtTagCompound = _nbtTagCompound.newInstance();

			_eP_writeNBT.invoke(entityPlayer, nbtTagCompound);

			if(!nbtValue.GetValue(params).SetValue(nbtTagCompound, value)) { return false; }
			
			_eP_readNBT.invoke(entityPlayer, nbtTagCompound);
			
			return true;
		}
		catch (IllegalAccessException | SecurityException e)
		{
			e.printStackTrace();
		}
		catch (InstantiationException | IllegalArgumentException | InvocationTargetException e)
		{

		}

		return false;
	}

	@Override
	public T GetValue(Map<String, Object> params)
	{
		try
		{
			return nbtValue.GetValue(params).GetValue(GetPlayerNBT(params));
		}
		catch (IllegalArgumentException	| SecurityException e)
		{
			e.printStackTrace();
		}

		return null;
	}

	protected Object GetPlayerNBT(Map<String, Object> params)
	{
		try
		{
			Object nbtTagCompound = _nbtTagCompound.newInstance();

			_eP_writeNBT.invoke(GetEntityPlayer(params), nbtTagCompound);

			return nbtTagCompound;
		}
		catch (InstantiationException | IllegalAccessException | IllegalArgumentException | InvocationTargetException
				| SecurityException e)
		{
			e.printStackTrace();
		}

		return null;
	}
	
	protected Object GetEntityPlayer(Map<String, Object> params)
	{
		try
		{
			return _cP_getHandle.invoke(GetPlayer(params));
		}
		catch (InvocationTargetException | IllegalAccessException e)
		{
			e.printStackTrace();
		}
		catch (IllegalArgumentException e)
		{
			
		}
		
		return null;
	}
	
	protected Player GetPlayer(Map<String, Object> params)
	{
		return Bukkit.getPlayer(playerUUID.GetValue(params));
	}

	@Override
	public boolean DoesMatch(Map<String, Object> params, T value)
	{
		return GetValue(params).equals(value);
	}
}
